/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.representations.info.Type;

public class FeatureRepresentation {
    private String name;
    private String label;
    private Type type;
    private boolean isEnabled;
    private Set<String> dependencies;

    public FeatureRepresentation() {
    }

    public FeatureRepresentation(Profile.Feature feature, boolean isEnabled) {
        this.name = feature.name();
        this.label = feature.getLabel();
        this.type = Type.valueOf(feature.getType().name());
        this.isEnabled = isEnabled;
        this.dependencies = feature.getDependencies() != null ? feature.getDependencies().stream().map(Enum::name).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public static List<FeatureRepresentation> create() {
        ArrayList<FeatureRepresentation> featureRepresentationList = new ArrayList<FeatureRepresentation>();
        Profile profile = Profile.getInstance();
        Map<Profile.Feature, Boolean> features = profile.getFeatures();
        features.forEach((f, enabled) -> featureRepresentationList.add(new FeatureRepresentation((Profile.Feature)((Object)f), (boolean)enabled)));
        return featureRepresentationList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        this.dependencies = dependencies;
    }
}

