/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.toaster.provider;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.sample.toaster.provider.ToasterProviderRuntimeMXBean;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.CancelToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToast;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.RestockToasterOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterOutOfBreadBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestockedBuilder;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={MakeToast.class}, immediate=true)
@Designate(ocd=Configuration.class)
public final class OpendaylightToaster
extends AbstractMXBean
implements MakeToast,
ToasterProviderRuntimeMXBean,
DataTreeChangeListener<Toaster>,
AutoCloseable {
    private static final CancelToastOutput EMPTY_CANCEL_OUTPUT = new CancelToastOutputBuilder().build();
    private static final MakeToastOutput EMPTY_MAKE_OUTPUT = new MakeToastOutputBuilder().build();
    private static final RestockToasterOutput EMPTY_RESTOCK_OUTPUT = new RestockToasterOutputBuilder().build();
    private static final Logger LOG = LoggerFactory.getLogger(OpendaylightToaster.class);
    private static final InstanceIdentifier<Toaster> TOASTER_IID = InstanceIdentifier.builder(Toaster.class).build();
    private static final String TOASTER_MANUFACTURER = "Opendaylight";
    private static final String TOASTER_MODEL_NUMBER = "Model 1 - Binding Aware";
    private final DataBroker dataBroker;
    private final NotificationPublishService notificationProvider;
    private final Registration dataTreeChangeListenerRegistration;
    private final Registration reg;
    private final ExecutorService executor;
    private final AtomicReference<Future<?>> currentMakeToastTask = new AtomicReference();
    private final AtomicLong amountOfBreadInStock = new AtomicLong(100L);
    private final AtomicLong toastsMade = new AtomicLong(0L);
    private final AtomicLong darknessFactor = new AtomicLong(1000L);
    private final @NonNull DisplayString manufacturer;
    private final @NonNull DisplayString modelNumber;
    private final int maxMakeToastTries;

    public OpendaylightToaster(DataBroker dataProvider, NotificationPublishService notificationPublishService, RpcProviderService rpcProviderService, String manufacturer, String modelNumber, int maxMakeToastTries) {
        super("OpendaylightToaster", "toaster-provider", null);
        this.notificationProvider = Objects.requireNonNull(notificationPublishService);
        this.dataBroker = Objects.requireNonNull(dataProvider);
        this.manufacturer = new DisplayString(manufacturer);
        this.modelNumber = new DisplayString(modelNumber);
        this.maxMakeToastTries = maxMakeToastTries;
        this.executor = Executors.newFixedThreadPool(1);
        this.reg = rpcProviderService.registerRpcImplementations(new Rpc[]{this::cancelToast, this, this::restockToaster});
        LOG.info("Initializing...");
        this.dataTreeChangeListenerRegistration = Objects.requireNonNull(this.dataBroker, "dataBroker must be set").registerTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, TOASTER_IID), (DataTreeChangeListener)this);
        try {
            this.setToasterStatusUp(null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Failed to commit initial data", e);
        }
        this.register();
    }

    @Inject
    public OpendaylightToaster(DataBroker dataProvider, NotificationPublishService notificationPublishService, RpcProviderService rpcProviderService) {
        this(dataProvider, notificationPublishService, rpcProviderService, TOASTER_MANUFACTURER, TOASTER_MODEL_NUMBER, 2);
    }

    @Activate
    public OpendaylightToaster(@Reference DataBroker dataProvider, @Reference NotificationPublishService notificationPublishService, @Reference RpcProviderService rpcProviderService, @NonNull Configuration configuration) {
        this(dataProvider, notificationPublishService, rpcProviderService, configuration.manufacturer(), configuration.modelNumber(), configuration.maxMakeToastTries());
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        LOG.info("Closing...");
        this.unregister();
        this.reg.close();
        this.executor.shutdown();
        if (this.dataTreeChangeListenerRegistration != null) {
            this.dataTreeChangeListenerRegistration.close();
        }
        if (this.dataBroker != null) {
            WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
            tx.delete(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
            Futures.addCallback((ListenableFuture)tx.commit(), (FutureCallback)new FutureCallback<CommitInfo>(this){

                public void onSuccess(CommitInfo result) {
                    LOG.debug("Successfully deleted the operational Toaster");
                }

                public void onFailure(Throwable failure) {
                    LOG.error("Delete of the operational Toaster failed", failure);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private Toaster buildToaster(Toaster.ToasterStatus status) {
        return new ToasterBuilder().setToasterManufacturer(this.manufacturer).setToasterModelNumber(this.modelNumber).setToasterStatus(status).build();
    }

    public void onDataTreeChanged(List<DataTreeModification<Toaster>> changes) {
        block4: for (DataTreeModification<Toaster> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            switch (rootNode.modificationType()) {
                case WRITE: {
                    Toaster oldToaster = (Toaster)rootNode.dataBefore();
                    Toaster newToaster = (Toaster)rootNode.dataAfter();
                    LOG.info("onDataTreeChanged - Toaster config with path {} was added or replaced: old Toaster: {}, new Toaster: {}", new Object[]{change.getRootPath().path(), oldToaster, newToaster});
                    Uint32 darkness = newToaster.getDarknessFactor();
                    if (darkness == null) continue block4;
                    this.darknessFactor.set(darkness.toJava());
                    break;
                }
                case DELETE: {
                    LOG.info("onDataTreeChanged - Toaster config with path {} was deleted: old Toaster: {}", (Object)change.getRootPath().path(), (Object)rootNode.dataBefore());
                    break;
                }
            }
        }
    }

    private ListenableFuture<RpcResult<CancelToastOutput>> cancelToast(CancelToastInput input) {
        Future current = this.currentMakeToastTask.getAndSet(null);
        if (current != null) {
            current.cancel(true);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)EMPTY_CANCEL_OUTPUT).build());
    }

    public ListenableFuture<RpcResult<MakeToastOutput>> invoke(MakeToastInput input) {
        LOG.info("makeToast: {}", (Object)input);
        SettableFuture futureResult = SettableFuture.create();
        this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult, this.maxMakeToastTries);
        return futureResult;
    }

    private static RpcError makeToasterOutOfBreadError() {
        return RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.RESOURCE_DENIED, (String)"Toaster is out of bread", (String)"out-of-stock", null, null);
    }

    private static RpcError makeToasterInUseError() {
        return RpcResultBuilder.newWarning((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.IN_USE, (String)"Toaster is busy", null, null, null);
    }

    private void checkStatusAndMakeToast(final MakeToastInput input, final SettableFuture<RpcResult<MakeToastOutput>> futureResult, final int tries) {
        ReadWriteTransaction tx = this.dataBroker.newReadWriteTransaction();
        FluentFuture readFuture = tx.read(LogicalDatastoreType.OPERATIONAL, TOASTER_IID);
        ListenableFuture commitFuture = Futures.transformAsync((ListenableFuture)readFuture, toasterData -> {
            Toaster.ToasterStatus toasterStatus = Toaster.ToasterStatus.Up;
            if (toasterData.isPresent()) {
                toasterStatus = ((Toaster)toasterData.orElseThrow()).getToasterStatus();
            }
            LOG.debug("Read toaster status: {}", (Object)toasterStatus);
            if (toasterStatus == Toaster.ToasterStatus.Up) {
                if (this.outOfBread()) {
                    LOG.debug("Toaster is out of bread");
                    tx.cancel();
                    return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.makeToasterOutOfBreadError()}));
                }
                LOG.debug("Setting Toaster status to Down");
                tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)this.buildToaster(Toaster.ToasterStatus.Down));
                return tx.commit();
            }
            LOG.debug("Oops - already making toast!");
            tx.cancel();
            return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("", new RpcError[]{OpendaylightToaster.makeToasterInUseError()}));
        }, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)commitFuture, (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                OpendaylightToaster.this.currentMakeToastTask.set(OpendaylightToaster.this.executor.submit(new MakeToastTask(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult)));
            }

            public void onFailure(Throwable ex) {
                if (ex instanceof OptimisticLockFailedException) {
                    if (tries - 1 > 0) {
                        LOG.debug("Got OptimisticLockFailedException - trying again");
                        OpendaylightToaster.this.checkStatusAndMakeToast(input, (SettableFuture<RpcResult<MakeToastOutput>>)futureResult, tries - 1);
                    } else {
                        futureResult.set((Object)RpcResultBuilder.failed().withError(ErrorType.APPLICATION, ex.getMessage()).build());
                    }
                } else if (ex instanceof TransactionCommitFailedException) {
                    LOG.debug("Failed to commit Toaster status", ex);
                    futureResult.set((Object)RpcResultBuilder.failed().withRpcErrors((Collection)((TransactionCommitFailedException)ex).getErrorList()).build());
                } else {
                    LOG.debug("Unexpected error committing Toaster status", ex);
                    futureResult.set((Object)RpcResultBuilder.failed().withError(ErrorType.APPLICATION, "Unexpected error committing Toaster status", ex).build());
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<RpcResult<RestockToasterOutput>> restockToaster(RestockToasterInput input) {
        LOG.info("restockToaster: {}", (Object)input);
        this.amountOfBreadInStock.set(input.getAmountOfBreadToStock().toJava());
        if (this.amountOfBreadInStock.get() > 0L) {
            ToasterRestocked reStockedNotification = new ToasterRestockedBuilder().setAmountOfBread(input.getAmountOfBreadToStock()).build();
            this.notificationProvider.offerNotification((Notification)reStockedNotification);
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)EMPTY_RESTOCK_OUTPUT).build());
    }

    @Override
    public void clearToastsMade() {
        LOG.info("clearToastsMade");
        this.toastsMade.set(0L);
    }

    @Override
    public Long getToastsMade() {
        return this.toastsMade.get();
    }

    private ListenableFuture<?> setToasterStatusUp(final Function<Boolean, MakeToastOutput> resultCallback) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, TOASTER_IID, (DataObject)this.buildToaster(Toaster.ToasterStatus.Up));
        FluentFuture future = tx.commit();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("Successfully set ToasterStatus to Up");
                this.notifyCallback(true);
            }

            public void onFailure(Throwable failure) {
                LOG.error("Failed to update toaster status", failure);
                this.notifyCallback(false);
            }

            void notifyCallback(boolean result) {
                if (resultCallback != null) {
                    resultCallback.apply(result);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    private boolean outOfBread() {
        return this.amountOfBreadInStock.get() == 0L;
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(description="The name of the toaster's manufacturer", max="255")
        public String manufacturer() default "Opendaylight";

        @AttributeDefinition(description="The name of the toaster's model", max="255")
        public String modelNumber() default "Model 1 - Binding Aware";

        @AttributeDefinition(description="How many times we attempt to make toast before failing ", min="0", max="65535")
        public int maxMakeToastTries() default 2;
    }

    private class MakeToastTask
    implements Callable<Void> {
        final MakeToastInput toastRequest;
        final SettableFuture<RpcResult<MakeToastOutput>> futureResult;

        MakeToastTask(MakeToastInput toastRequest, SettableFuture<RpcResult<MakeToastOutput>> futureResult) {
            this.toastRequest = toastRequest;
            this.futureResult = futureResult;
        }

        @Override
        public Void call() {
            try {
                Thread.sleep(OpendaylightToaster.this.darknessFactor.get() * this.toastRequest.getToasterDoneness().toJava());
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while making the toast");
            }
            OpendaylightToaster.this.toastsMade.incrementAndGet();
            OpendaylightToaster.this.amountOfBreadInStock.getAndDecrement();
            if (OpendaylightToaster.this.outOfBread()) {
                LOG.info("Toaster is out of bread!");
                OpendaylightToaster.this.notificationProvider.offerNotification((Notification)new ToasterOutOfBreadBuilder().build());
            }
            OpendaylightToaster.this.setToasterStatusUp(result -> {
                OpendaylightToaster.this.currentMakeToastTask.set(null);
                LOG.debug("Toast done");
                this.futureResult.set((Object)RpcResultBuilder.success((Object)EMPTY_MAKE_OUTPUT).build());
                return null;
            });
            return null;
        }
    }
}

