/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.controller.cluster.raft.behaviors.LeaderInstallSnapshotState;

public final class FollowerLogInformation {
    public static final long NO_INDEX = -1L;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final RaftActorContext context;
    private long nextIndex;
    private long matchIndex;
    private long lastReplicatedIndex = -1L;
    private long sentCommitIndex = -1L;
    private final Stopwatch lastReplicatedStopwatch = Stopwatch.createUnstarted();
    private short payloadVersion = (short)-1;
    private short raftVersion = (short)4;
    private final PeerInfo peerInfo;
    private LeaderInstallSnapshotState installSnapshotState;
    private long slicedLogEntryIndex = -1L;
    private boolean needsLeaderAddress;

    @VisibleForTesting
    FollowerLogInformation(PeerInfo peerInfo, long matchIndex, RaftActorContext context) {
        this.nextIndex = context.getCommitIndex();
        this.matchIndex = matchIndex;
        this.context = context;
        this.peerInfo = Objects.requireNonNull(peerInfo);
    }

    public FollowerLogInformation(PeerInfo peerInfo, RaftActorContext context) {
        this(peerInfo, -1L, context);
    }

    @VisibleForTesting
    long incrNextIndex() {
        return this.nextIndex++;
    }

    public boolean decrNextIndex(long followerLastIndex) {
        if (this.nextIndex < 0L) {
            return false;
        }
        this.nextIndex = followerLastIndex >= 0L && this.nextIndex > followerLastIndex ? followerLastIndex : --this.nextIndex;
        return true;
    }

    public boolean setNextIndex(long nextIndex) {
        if (this.nextIndex != nextIndex) {
            this.nextIndex = nextIndex;
            return true;
        }
        return false;
    }

    public long incrMatchIndex() {
        return this.matchIndex++;
    }

    public boolean setMatchIndex(long matchIndex) {
        if (this.isLogEntrySlicingInProgress() && this.slicedLogEntryIndex == matchIndex) {
            this.slicedLogEntryIndex = -1L;
        }
        if (this.matchIndex != matchIndex) {
            this.matchIndex = matchIndex;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.peerInfo.getId();
    }

    public long getNextIndex() {
        return this.nextIndex;
    }

    public long getMatchIndex() {
        return this.matchIndex;
    }

    public boolean isFollowerActive() {
        if (this.peerInfo.getVotingState() == VotingState.VOTING_NOT_INITIALIZED) {
            return false;
        }
        long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        return this.stopwatch.isRunning() && elapsed <= this.context.getConfigParams().getElectionTimeOutInterval().toMillis();
    }

    public void markFollowerActive() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.reset();
        }
        this.stopwatch.start();
    }

    @VisibleForTesting
    public void markFollowerInActive() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
    }

    public long nanosSinceLastActivity() {
        return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
    }

    public boolean okToReplicate(long commitIndex) {
        if (this.peerInfo.getVotingState() == VotingState.VOTING_NOT_INITIALIZED) {
            return false;
        }
        if (this.getNextIndex() == this.lastReplicatedIndex && !this.hasStaleCommitIndex(commitIndex) && this.lastReplicatedStopwatch.elapsed(TimeUnit.MILLISECONDS) < this.context.getConfigParams().getHeartBeatInterval().toMillis()) {
            return false;
        }
        this.resetLastReplicated();
        return true;
    }

    private void resetLastReplicated() {
        this.lastReplicatedIndex = this.getNextIndex();
        if (this.lastReplicatedStopwatch.isRunning()) {
            this.lastReplicatedStopwatch.reset();
        }
        this.lastReplicatedStopwatch.start();
    }

    public short getPayloadVersion() {
        return this.payloadVersion;
    }

    public void setPayloadVersion(short payloadVersion) {
        this.payloadVersion = payloadVersion;
    }

    public short getRaftVersion() {
        return this.raftVersion;
    }

    public void setRaftVersion(short raftVersion) {
        Preconditions.checkArgument((raftVersion >= 4 ? 1 : 0) != 0, (String)"Unexpected version %s", (int)raftVersion);
        this.raftVersion = raftVersion;
    }

    public @Nullable LeaderInstallSnapshotState getInstallSnapshotState() {
        return this.installSnapshotState;
    }

    public void setLeaderInstallSnapshotState(@NonNull LeaderInstallSnapshotState state) {
        if (this.installSnapshotState == null) {
            this.installSnapshotState = Objects.requireNonNull(state);
        }
    }

    public void clearLeaderInstallSnapshotState() {
        Preconditions.checkState((this.installSnapshotState != null ? 1 : 0) != 0);
        this.installSnapshotState.close();
        this.installSnapshotState = null;
    }

    public void setSlicedLogEntryIndex(long index) {
        this.slicedLogEntryIndex = index;
    }

    public boolean isLogEntrySlicingInProgress() {
        return this.slicedLogEntryIndex != -1L;
    }

    public void setNeedsLeaderAddress(boolean value) {
        this.needsLeaderAddress = value;
    }

    public @Nullable String needsLeaderAddress(String leaderId) {
        return this.needsLeaderAddress ? this.context.getPeerAddress(leaderId) : null;
    }

    public boolean hasStaleCommitIndex(long commitIndex) {
        return this.sentCommitIndex != commitIndex;
    }

    public void setSentCommitIndex(long commitIndex) {
        this.sentCommitIndex = commitIndex;
    }

    public String toString() {
        return "FollowerLogInformation [id=" + this.getId() + ", nextIndex=" + this.nextIndex + ", matchIndex=" + this.matchIndex + ", lastReplicatedIndex=" + this.lastReplicatedIndex + ", commitIndex=" + this.sentCommitIndex + ", votingState=" + String.valueOf((Object)this.peerInfo.getVotingState()) + ", stopwatch=" + this.stopwatch.elapsed(TimeUnit.MILLISECONDS) + ", followerTimeoutMillis=" + this.context.getConfigParams().getElectionTimeOutInterval().toMillis() + "]";
    }
}

