/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.actor.Status;
import akka.persistence.AbstractPersistentActor;
import akka.persistence.JournalProtocol;
import akka.persistence.SnapshotProtocol;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.DelegatingPersistentDataProvider;
import org.opendaylight.controller.cluster.NonPersistentDataProvider;
import org.opendaylight.controller.cluster.PersistentDataProvider;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedPersistentActor;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfActor;
import org.opendaylight.controller.cluster.mgmt.api.FollowerInfo;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RoleChanged;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.DefaultConfigParamsImpl;
import org.opendaylight.controller.cluster.raft.ElectionTermImpl;
import org.opendaylight.controller.cluster.raft.LeadershipTransferFailedException;
import org.opendaylight.controller.cluster.raft.NoopProcedure;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftActorContextImpl;
import org.opendaylight.controller.cluster.raft.RaftActorDelegatingPersistentDataProvider;
import org.opendaylight.controller.cluster.raft.RaftActorLeadershipTransferCohort;
import org.opendaylight.controller.cluster.raft.RaftActorRecoveryCohort;
import org.opendaylight.controller.cluster.raft.RaftActorRecoverySupport;
import org.opendaylight.controller.cluster.raft.RaftActorServerConfigurationSupport;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotMessageSupport;
import org.opendaylight.controller.cluster.raft.RaftEntryMeta;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.ReplicatedLogImpl;
import org.opendaylight.controller.cluster.raft.SnapshotManager;
import org.opendaylight.controller.cluster.raft.TimedRunnable;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.base.messages.CheckConsensusReached;
import org.opendaylight.controller.cluster.raft.base.messages.InitiateCaptureSnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.LeaderTransitioning;
import org.opendaylight.controller.cluster.raft.base.messages.Replicate;
import org.opendaylight.controller.cluster.raft.base.messages.SwitchBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractLeader;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractRaftActorBehavior;
import org.opendaylight.controller.cluster.raft.behaviors.Follower;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeader;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeaderReply;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.messages.RequestLeadership;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.opendaylight.controller.cluster.raft.persisted.NoopPayload;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;

public abstract class RaftActor
extends AbstractUntypedPersistentActor {
    private static final long APPLY_STATE_DELAY_THRESHOLD_IN_NANOS = TimeUnit.MILLISECONDS.toNanos(50L);
    private final RaftActorContextImpl context;
    private final DelegatingPersistentDataProvider delegatingPersistenceProvider;
    private final PersistentDataProvider persistentProvider;
    private final BehaviorStateTracker behaviorStateTracker = new BehaviorStateTracker();
    private RaftActorRecoverySupport raftRecovery;
    private RaftActorSnapshotMessageSupport snapshotSupport;
    private RaftActorServerConfigurationSupport serverConfigurationSupport;
    private boolean shuttingDown;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Akka class design")
    protected RaftActor(String id, Map<String, String> peerAddresses, Optional<ConfigParams> configParams, short payloadVersion) {
        this.persistentProvider = new PersistentDataProvider((AbstractPersistentActor)this);
        this.delegatingPersistenceProvider = new RaftActorDelegatingPersistentDataProvider(null, this.persistentProvider);
        this.context = new RaftActorContextImpl(this.getSelf(), (ActorContext)this.getContext(), id, new ElectionTermImpl((DataPersistenceProvider)this.persistentProvider, id, this.LOG), -1L, -1L, peerAddresses, configParams.isPresent() ? configParams.orElseThrow() : new DefaultConfigParamsImpl(), (DataPersistenceProvider)this.delegatingPersistenceProvider, this::handleApplyState, this.LOG, arg_0 -> ((RaftActor)this).executeInSelf(arg_0));
        this.context.setPayloadVersion(payloadVersion);
        this.context.setReplicatedLog(ReplicatedLogImpl.newInstance(this.context));
    }

    public void preStart() throws Exception {
        this.LOG.info("Starting recovery for {} with journal batch size {}", (Object)this.persistenceId(), (Object)this.context.getConfigParams().getJournalRecoveryLogBatchSize());
        super.preStart();
        this.snapshotSupport = this.newRaftActorSnapshotMessageSupport();
        this.serverConfigurationSupport = new RaftActorServerConfigurationSupport(this);
    }

    public void postStop() throws Exception {
        this.context.close();
        super.postStop();
    }

    protected void handleRecover(Object message) {
        boolean recoveryComplete;
        if (this.raftRecovery == null) {
            this.raftRecovery = this.newRaftActorRecoverySupport();
        }
        if (recoveryComplete = this.raftRecovery.handleRecoveryMessage(message, this.persistentProvider)) {
            this.onRecoveryComplete();
            this.initializeBehavior();
            this.raftRecovery = null;
        }
    }

    protected RaftActorRecoverySupport newRaftActorRecoverySupport() {
        return new RaftActorRecoverySupport(this.context, this.getRaftActorRecoveryCohort());
    }

    @VisibleForTesting
    void initializeBehavior() {
        this.changeCurrentBehavior(new Follower(this.context));
    }

    @VisibleForTesting
    protected void changeCurrentBehavior(RaftActorBehavior newBehavior) {
        RaftActorBehavior currentBehavior = this.getCurrentBehavior();
        if (currentBehavior != null) {
            try {
                currentBehavior.close();
            }
            catch (Exception e) {
                this.LOG.warn("{}: Error closing behavior {}", new Object[]{this.persistence(), currentBehavior, e});
            }
        }
        BehaviorState state = this.behaviorStateTracker.capture(currentBehavior);
        this.setCurrentBehavior(newBehavior);
        this.handleBehaviorChange(state, newBehavior);
    }

    protected void handleNonRaftCommand(Object message) {
        this.unhandled(message);
    }

    @Deprecated
    protected void handleCommand(Object message) {
        if (this.serverConfigurationSupport.handleMessage(message, this.getSender())) {
            return;
        }
        if (this.snapshotSupport.handleSnapshotMessage(message, this.getSender())) {
            return;
        }
        if (message instanceof ApplyState) {
            ApplyState applyState = (ApplyState)message;
            if (!this.hasFollowers()) {
                this.context.getReplicatedLog().captureSnapshotIfReady(applyState.getReplicatedLogEntry());
                this.context.getSnapshotManager().trimLog(this.context.getLastApplied());
            }
            this.possiblyHandleBehaviorMessage(message);
        } else if (message instanceof ApplyJournalEntries) {
            ApplyJournalEntries applyEntries = (ApplyJournalEntries)message;
            this.LOG.debug("{}: Persisting ApplyJournalEntries with index={}", (Object)this.persistenceId(), (Object)applyEntries.getToIndex());
            this.persistence().persistAsync((Object)applyEntries, NoopProcedure.instance());
        } else if (message instanceof FindLeader) {
            this.getSender().tell((Object)new FindLeaderReply(this.getLeaderAddress()), this.getSelf());
        } else if (message instanceof GetOnDemandRaftState) {
            this.onGetOnDemandRaftStats();
        } else if (message instanceof InitiateCaptureSnapshot) {
            this.captureSnapshot();
        } else if (message instanceof SwitchBehavior) {
            SwitchBehavior switchBehavior = (SwitchBehavior)message;
            this.switchBehavior(switchBehavior);
        } else if (message instanceof LeaderTransitioning) {
            LeaderTransitioning leaderTransitioning = (LeaderTransitioning)message;
            this.onLeaderTransitioning(leaderTransitioning);
        } else if (message instanceof Shutdown) {
            this.onShutDown();
        } else if (message instanceof Runnable) {
            Runnable runnable = (Runnable)message;
            runnable.run();
        } else if (message instanceof NoopPayload) {
            NoopPayload noopPayload = (NoopPayload)message;
            this.persistData(null, null, noopPayload, false);
        } else if (message instanceof RequestLeadership) {
            RequestLeadership requestLeadership = (RequestLeadership)message;
            this.onRequestLeadership(requestLeadership);
        } else if (!this.possiblyHandleBehaviorMessage(message)) {
            SnapshotProtocol.Response response;
            JournalProtocol.Response response2;
            if (message instanceof JournalProtocol.Response && this.delegatingPersistenceProvider.handleJournalResponse(response2 = (JournalProtocol.Response)message)) {
                this.LOG.debug("{}: handled a journal response", (Object)this.persistenceId());
            } else if (message instanceof SnapshotProtocol.Response && this.delegatingPersistenceProvider.handleSnapshotResponse(response = (SnapshotProtocol.Response)message)) {
                this.LOG.debug("{}: handled a snapshot response", (Object)this.persistenceId());
            } else {
                this.handleNonRaftCommand(message);
            }
        }
    }

    private void onRequestLeadership(RequestLeadership message) {
        this.LOG.debug("{}: onRequestLeadership {}", (Object)this.persistenceId(), (Object)message);
        if (!this.isLeader()) {
            this.LOG.warn("{}: onRequestLeadership {} was sent to non-leader. Current behavior: {}. Sending failure response", new Object[]{this.persistenceId(), message, this.getCurrentBehavior().state()});
            message.getReplyTo().tell((Object)new LeadershipTransferFailedException("Cannot transfer leader to " + message.getRequestedFollowerId() + ". RequestLeadership message was sent to non-leader " + this.persistenceId()), this.getSelf());
            return;
        }
        final String requestedFollowerId = message.getRequestedFollowerId();
        final ActorRef replyTo = message.getReplyTo();
        this.initiateLeadershipTransfer(new RaftActorLeadershipTransferCohort.OnComplete(){

            @Override
            public void onSuccess(ActorRef raftActorRef) {
                if (!requestedFollowerId.equals(RaftActor.this.getLeaderId())) {
                    this.onFailure(raftActorRef);
                }
                RaftActor.this.LOG.debug("{}: Leadership transferred successfully to {}", (Object)RaftActor.this.persistenceId(), (Object)requestedFollowerId);
                replyTo.tell((Object)new Status.Success(null), RaftActor.this.getSelf());
            }

            @Override
            public void onFailure(ActorRef raftActorRef) {
                RaftActor.this.LOG.debug("{}: LeadershipTransfer request from {} failed", (Object)RaftActor.this.persistenceId(), (Object)requestedFollowerId);
                replyTo.tell((Object)new Status.Failure((Throwable)new LeadershipTransferFailedException("Failed to transfer leadership to " + requestedFollowerId + ". Follower is not ready to become leader")), RaftActor.this.getSelf());
            }
        }, message.getRequestedFollowerId(), -1L);
    }

    private boolean possiblyHandleBehaviorMessage(Object message) {
        RaftActorBehavior currentBehavior = this.getCurrentBehavior();
        BehaviorState state = this.behaviorStateTracker.capture(currentBehavior);
        RaftActorBehavior nextBehavior = currentBehavior.handleMessage(this.getSender(), message);
        if (nextBehavior != null) {
            this.switchBehavior(state, nextBehavior);
            return true;
        }
        return false;
    }

    private void initiateLeadershipTransfer(RaftActorLeadershipTransferCohort.OnComplete onComplete, @Nullable String followerId, long newLeaderTimeoutInMillis) {
        this.LOG.debug("{}: Initiating leader transfer", (Object)this.persistenceId());
        RaftActorLeadershipTransferCohort leadershipTransferInProgress = this.context.getRaftActorLeadershipTransferCohort();
        if (leadershipTransferInProgress == null) {
            leadershipTransferInProgress = new RaftActorLeadershipTransferCohort(this, followerId);
            leadershipTransferInProgress.setNewLeaderTimeoutInMillis(newLeaderTimeoutInMillis);
            leadershipTransferInProgress.addOnComplete(new RaftActorLeadershipTransferCohort.OnComplete(){

                @Override
                public void onSuccess(ActorRef raftActorRef) {
                    RaftActor.this.context.setRaftActorLeadershipTransferCohort(null);
                }

                @Override
                public void onFailure(ActorRef raftActorRef) {
                    RaftActor.this.context.setRaftActorLeadershipTransferCohort(null);
                }
            });
            leadershipTransferInProgress.addOnComplete(onComplete);
            this.context.setRaftActorLeadershipTransferCohort(leadershipTransferInProgress);
            leadershipTransferInProgress.init();
        } else {
            this.LOG.debug("{}: prior leader transfer in progress - adding callback", (Object)this.persistenceId());
            leadershipTransferInProgress.addOnComplete(onComplete);
        }
    }

    private void onShutDown() {
        this.LOG.debug("{}: onShutDown", (Object)this.persistenceId());
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        RaftActorBehavior currentBehavior = this.context.getCurrentBehavior();
        switch (currentBehavior.state()) {
            case Leader: 
            case PreLeader: {
                break;
            }
            default: {
                this.self().tell((Object)PoisonPill.getInstance(), this.self());
                return;
            }
        }
        if (this.context.hasFollowers()) {
            this.initiateLeadershipTransfer(new RaftActorLeadershipTransferCohort.OnComplete(){

                @Override
                public void onSuccess(ActorRef raftActorRef) {
                    RaftActor.this.LOG.debug("{}: leader transfer succeeded - sending PoisonPill", (Object)RaftActor.this.persistenceId());
                    raftActorRef.tell((Object)PoisonPill.getInstance(), raftActorRef);
                }

                @Override
                public void onFailure(ActorRef raftActorRef) {
                    RaftActor.this.LOG.debug("{}: leader transfer failed - sending PoisonPill", (Object)RaftActor.this.persistenceId());
                    raftActorRef.tell((Object)PoisonPill.getInstance(), raftActorRef);
                }
            }, null, TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS));
        } else {
            this.pauseLeader(new TimedRunnable(this.context.getConfigParams().getElectionTimeOutInterval(), this){

                @Override
                protected void doRun() {
                    RaftActor.this.self().tell((Object)PoisonPill.getInstance(), RaftActor.this.self());
                }

                @Override
                protected void doCancel() {
                    RaftActor.this.self().tell((Object)PoisonPill.getInstance(), RaftActor.this.self());
                }
            });
        }
    }

    private void onLeaderTransitioning(LeaderTransitioning leaderTransitioning) {
        this.LOG.debug("{}: onLeaderTransitioning: {}", (Object)this.persistenceId(), (Object)leaderTransitioning);
        Optional<ActorRef> roleChangeNotifier = this.getRoleChangeNotifier();
        if (this.getRaftState() == RaftState.Follower && roleChangeNotifier.isPresent() && leaderTransitioning.getLeaderId().equals(this.getCurrentBehavior().getLeaderId())) {
            roleChangeNotifier.orElseThrow().tell((Object)this.newLeaderStateChanged(this.getId(), null, this.getCurrentBehavior().getLeaderPayloadVersion()), this.getSelf());
        }
    }

    private void switchBehavior(SwitchBehavior message) {
        if (!this.getRaftActorContext().getRaftPolicy().automaticElectionsEnabled()) {
            RaftState newState = message.getNewState();
            if (newState == RaftState.Leader || newState == RaftState.Follower) {
                this.getRaftActorContext().getTermInformation().updateAndPersist(message.getNewTerm(), "");
                this.switchBehavior(this.behaviorStateTracker.capture(this.getCurrentBehavior()), AbstractRaftActorBehavior.createBehavior(this.context, message.getNewState()));
            } else {
                this.LOG.warn("Switching to behavior : {} - not supported", (Object)newState);
            }
        }
    }

    private void switchBehavior(BehaviorState oldBehaviorState, RaftActorBehavior nextBehavior) {
        this.setCurrentBehavior(nextBehavior);
        this.handleBehaviorChange(oldBehaviorState, nextBehavior);
    }

    @VisibleForTesting
    RaftActorSnapshotMessageSupport newRaftActorSnapshotMessageSupport() {
        return new RaftActorSnapshotMessageSupport(this.context, this.getRaftActorSnapshotCohort());
    }

    private void onGetOnDemandRaftStats() {
        HashMap<String, String> peerAddresses = new HashMap<String, String>();
        HashMap<String, Boolean> peerVotingStates = new HashMap<String, Boolean>();
        for (PeerInfo info2 : this.context.getPeers()) {
            peerVotingStates.put(info2.getId(), info2.isVoting());
            peerAddresses.put(info2.getId(), info2.getAddress() != null ? info2.getAddress() : "");
        }
        RaftActorBehavior currentBehavior = this.context.getCurrentBehavior();
        Object builder = ((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)this.newOnDemandRaftStateBuilder().commitIndex(this.context.getCommitIndex())).currentTerm(this.context.getTermInformation().getCurrentTerm())).inMemoryJournalDataSize(this.replicatedLog().dataSize())).inMemoryJournalLogSize(this.replicatedLog().size())).isSnapshotCaptureInitiated(this.context.getSnapshotManager().isCapturing())).lastApplied(this.context.getLastApplied())).lastIndex(this.replicatedLog().lastIndex())).lastTerm(this.replicatedLog().lastTerm())).leader(this.getLeaderId())).raftState(currentBehavior.state().toString())).replicatedToAllIndex(currentBehavior.getReplicatedToAllIndex())).snapshotIndex(this.replicatedLog().getSnapshotIndex())).snapshotTerm(this.replicatedLog().getSnapshotTerm())).votedFor(this.context.getTermInformation().getVotedFor())).isVoting(this.context.isVotingMember())).peerAddresses(peerAddresses)).peerVotingStates(peerVotingStates)).customRaftPolicyClassName(this.context.getConfigParams().getCustomRaftPolicyImplementationClass());
        RaftEntryMeta lastLogEntry = this.replicatedLog().lastMeta();
        if (lastLogEntry != null) {
            ((OnDemandRaftState.AbstractBuilder)((OnDemandRaftState.AbstractBuilder)builder).lastLogIndex(lastLogEntry.index())).lastLogTerm(lastLogEntry.term());
        }
        if (currentBehavior instanceof AbstractLeader) {
            AbstractLeader leader = (AbstractLeader)currentBehavior;
            ((OnDemandRaftState.AbstractBuilder)builder).followerInfoList((List)leader.getFollowerIds().stream().map(leader::getFollower).map(info -> new FollowerInfo(info.getId(), info.getNextIndex(), info.getMatchIndex(), info.isFollowerActive(), DurationFormatUtils.formatDurationHMS((long)TimeUnit.NANOSECONDS.toMillis(info.nanosSinceLastActivity())), this.context.getPeerInfo(info.getId()).isVoting())).collect(ImmutableList.toImmutableList()));
        }
        this.sender().tell(((OnDemandRaftState.AbstractBuilder)builder).build(), this.self());
    }

    protected OnDemandRaftState.AbstractBuilder<?, ?> newOnDemandRaftStateBuilder() {
        return OnDemandRaftState.builder();
    }

    private void handleBehaviorChange(BehaviorState oldBehaviorState, RaftActorBehavior currentBehavior) {
        RaftActorBehavior oldBehavior = oldBehaviorState.getBehavior();
        if (oldBehavior != currentBehavior) {
            this.onStateChanged();
        }
        String lastLeaderId = oldBehavior == null ? null : oldBehaviorState.getLastLeaderId();
        String lastValidLeaderId = oldBehavior == null ? null : oldBehaviorState.getLastValidLeaderId();
        String oldBehaviorStateName = oldBehavior == null ? null : oldBehavior.state().name();
        Optional<ActorRef> roleChangeNotifier = this.getRoleChangeNotifier();
        if (!Objects.equals(lastLeaderId, currentBehavior.getLeaderId()) || oldBehaviorState.getLeaderPayloadVersion() != currentBehavior.getLeaderPayloadVersion()) {
            if (roleChangeNotifier.isPresent()) {
                roleChangeNotifier.orElseThrow().tell((Object)this.newLeaderStateChanged(this.getId(), currentBehavior.getLeaderId(), currentBehavior.getLeaderPayloadVersion()), this.getSelf());
            }
            this.onLeaderChanged(lastValidLeaderId, currentBehavior.getLeaderId());
            RaftActorLeadershipTransferCohort leadershipTransferInProgress = this.context.getRaftActorLeadershipTransferCohort();
            if (leadershipTransferInProgress != null) {
                leadershipTransferInProgress.onNewLeader(currentBehavior.getLeaderId());
            }
            this.serverConfigurationSupport.onNewLeader(currentBehavior.getLeaderId());
        }
        if (roleChangeNotifier.isPresent() && (oldBehavior == null || oldBehavior.state() != currentBehavior.state())) {
            roleChangeNotifier.orElseThrow().tell((Object)new RoleChanged(this.getId(), oldBehaviorStateName, currentBehavior.state().name()), this.getSelf());
        }
    }

    private void handleApplyState(ApplyState applyState) {
        long elapsedTime;
        long startTime = System.nanoTime();
        ReplicatedLogEntry entry = applyState.getReplicatedLogEntry();
        Payload payload = entry.getData();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("{}: Applying state for log index {} data {}", new Object[]{this.persistenceId(), entry.index(), payload});
        }
        if (!(payload instanceof NoopPayload) && !(payload instanceof ServerConfigurationPayload)) {
            this.applyState(applyState.getClientActor(), applyState.getIdentifier(), payload);
        }
        if ((elapsedTime = System.nanoTime() - startTime) >= APPLY_STATE_DELAY_THRESHOLD_IN_NANOS) {
            this.LOG.debug("ApplyState took more time than expected. Elapsed Time = {} ms ApplyState = {}", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedTime), (Object)applyState);
        }
        this.self().tell((Object)applyState, this.self());
    }

    protected LeaderStateChanged newLeaderStateChanged(String memberId, String leaderId, short leaderPayloadVersion) {
        return new LeaderStateChanged(memberId, leaderId, leaderPayloadVersion);
    }

    public long snapshotSequenceNr() {
        return this.context.getSnapshotManager().getLastSequenceNumber();
    }

    protected final void persistData(ActorRef clientActor, Identifier identifier, Payload data, boolean batchHint) {
        SimpleReplicatedLogEntry replicatedLogEntry = new SimpleReplicatedLogEntry(this.context.getReplicatedLog().lastIndex() + 1L, this.context.getTermInformation().getCurrentTerm(), data);
        replicatedLogEntry.setPersistencePending(true);
        this.LOG.debug("{}: Persist data {}", (Object)this.persistenceId(), (Object)replicatedLogEntry);
        RaftActorContext raftContext = this.getRaftActorContext();
        boolean wasAppended = this.replicatedLog().appendAndPersist(replicatedLogEntry, persistedLogEntry -> {
            persistedLogEntry.setPersistencePending(false);
            if (!this.hasFollowers()) {
                raftContext.setCommitIndex(persistedLogEntry.index());
                raftContext.setLastApplied(persistedLogEntry.index());
                this.handleApplyState(new ApplyState(clientActor, identifier, (ReplicatedLogEntry)persistedLogEntry));
                this.self().tell((Object)new ApplyJournalEntries(persistedLogEntry.index()), this.self());
            } else {
                this.context.getReplicatedLog().captureSnapshotIfReady(replicatedLogEntry);
                this.getCurrentBehavior().handleMessage(this.getSelf(), CheckConsensusReached.INSTANCE);
            }
        }, true);
        if (wasAppended && this.hasFollowers()) {
            this.getCurrentBehavior().handleMessage(this.getSelf(), new Replicate(replicatedLogEntry.index(), !batchHint, clientActor, identifier));
        }
    }

    private ReplicatedLog replicatedLog() {
        return this.context.getReplicatedLog();
    }

    protected String getId() {
        return this.context.getId();
    }

    @VisibleForTesting
    void setCurrentBehavior(RaftActorBehavior behavior) {
        this.context.setCurrentBehavior(behavior);
    }

    protected RaftActorBehavior getCurrentBehavior() {
        return this.context.getCurrentBehavior();
    }

    protected boolean isLeader() {
        return this.context.getId().equals(this.getCurrentBehavior().getLeaderId());
    }

    protected final boolean isLeaderActive() {
        return this.getRaftState() != RaftState.IsolatedLeader && this.getRaftState() != RaftState.PreLeader && !this.shuttingDown && !this.isLeadershipTransferInProgress();
    }

    protected boolean isLeadershipTransferInProgress() {
        RaftActorLeadershipTransferCohort leadershipTransferInProgress = this.context.getRaftActorLeadershipTransferCohort();
        return leadershipTransferInProgress != null && leadershipTransferInProgress.isTransferring();
    }

    public ActorSelection getLeader() {
        String leaderAddress = this.getLeaderAddress();
        if (leaderAddress == null) {
            return null;
        }
        return this.context.actorSelection(leaderAddress);
    }

    protected final String getLeaderId() {
        return this.getCurrentBehavior().getLeaderId();
    }

    @VisibleForTesting
    protected final RaftState getRaftState() {
        return this.getCurrentBehavior().state();
    }

    protected Long getCurrentTerm() {
        return this.context.getTermInformation().getCurrentTerm();
    }

    protected RaftActorContext getRaftActorContext() {
        return this.context;
    }

    protected void updateConfigParams(ConfigParams configParams) {
        String oldRaftPolicy = this.context.getConfigParams().getCustomRaftPolicyImplementationClass();
        String newRaftPolicy = configParams.getCustomRaftPolicyImplementationClass();
        this.LOG.debug("{}: RaftPolicy used with prev.config {}, RaftPolicy used with newConfig {}", new Object[]{this.persistenceId(), oldRaftPolicy, newRaftPolicy});
        this.context.setConfigParams(configParams);
        if (!Objects.equals(oldRaftPolicy, newRaftPolicy)) {
            RaftActorBehavior behavior = this.getCurrentBehavior();
            if (behavior != null && behavior.state() == RaftState.Follower) {
                String previousLeaderId = behavior.getLeaderId();
                short previousLeaderPayloadVersion = behavior.getLeaderPayloadVersion();
                this.LOG.debug("{}: Re-initializing to Follower with previous leaderId {}", (Object)this.persistenceId(), (Object)previousLeaderId);
                this.changeCurrentBehavior(new Follower(this.context, previousLeaderId, previousLeaderPayloadVersion));
            } else {
                this.initializeBehavior();
            }
        }
    }

    public final DataPersistenceProvider persistence() {
        return this.delegatingPersistenceProvider.getDelegate();
    }

    public void setPersistence(DataPersistenceProvider provider) {
        this.delegatingPersistenceProvider.setDelegate(provider);
    }

    protected void setPersistence(boolean persistent) {
        DataPersistenceProvider currentPersistence = this.persistence();
        if (persistent && (currentPersistence == null || !currentPersistence.isRecoveryApplicable())) {
            this.setPersistence((DataPersistenceProvider)new PersistentDataProvider((AbstractPersistentActor)this));
            if (this.getCurrentBehavior() != null) {
                this.LOG.info("{}: Persistence has been enabled - capturing snapshot", (Object)this.persistenceId());
                this.captureSnapshot();
            }
        } else if (!persistent && (currentPersistence == null || currentPersistence.isRecoveryApplicable())) {
            this.setPersistence((DataPersistenceProvider)new NonPersistentDataProvider((ExecuteInSelfActor)this){

                public void saveSnapshot(Object object) {
                    RaftActor.this.self().tell(RaftActorSnapshotMessageSupport.COMMIT_SNAPSHOT, RaftActor.this.self());
                }
            });
        }
    }

    protected void setPeerAddress(String peerId, String peerAddress) {
        this.context.setPeerAddress(peerId, peerAddress);
    }

    protected abstract void applyState(ActorRef var1, Identifier var2, Object var3);

    protected abstract @NonNull RaftActorRecoveryCohort getRaftActorRecoveryCohort();

    protected abstract void onRecoveryComplete();

    protected abstract @NonNull RaftActorSnapshotCohort getRaftActorSnapshotCohort();

    protected abstract void onStateChanged();

    protected abstract Optional<ActorRef> getRoleChangeNotifier();

    protected void onVotingStateChangeComplete() {
    }

    protected void pauseLeader(Runnable operation) {
        operation.run();
    }

    protected void unpauseLeader() {
    }

    protected void onLeaderChanged(String oldLeader, String newLeader) {
    }

    private String getLeaderAddress() {
        if (this.isLeader()) {
            return this.getSelf().path().toString();
        }
        String leaderId = this.getLeaderId();
        if (leaderId == null) {
            return null;
        }
        String peerAddress = this.context.getPeerAddress(leaderId);
        this.LOG.debug("{}: getLeaderAddress leaderId = {} peerAddress = {}", new Object[]{this.persistenceId(), leaderId, peerAddress});
        return peerAddress;
    }

    protected boolean hasFollowers() {
        return this.getRaftActorContext().hasFollowers();
    }

    private void captureSnapshot() {
        SnapshotManager snapshotManager = this.context.getSnapshotManager();
        if (!snapshotManager.isCapturing()) {
            long idx = this.getCurrentBehavior().getReplicatedToAllIndex();
            RaftEntryMeta last = this.replicatedLog().lastMeta();
            this.LOG.debug("Take a snapshot of current state. lastReplicatedLog is {} and replicatedToAllIndex is {}", (Object)last, (Object)idx);
            snapshotManager.captureWithForcedTrim(last, idx);
        }
    }

    void becomeNonVoting() {
        if (this.isLeader()) {
            this.initiateLeadershipTransfer(new RaftActorLeadershipTransferCohort.OnComplete(){

                @Override
                public void onSuccess(ActorRef raftActorRef) {
                    RaftActor.this.LOG.debug("{}: leader transfer succeeded after change to non-voting", (Object)RaftActor.this.persistenceId());
                    this.ensureFollowerState();
                }

                @Override
                public void onFailure(ActorRef raftActorRef) {
                    RaftActor.this.LOG.debug("{}: leader transfer failed after change to non-voting", (Object)RaftActor.this.persistenceId());
                    this.ensureFollowerState();
                }

                private void ensureFollowerState() {
                    if (RaftActor.this.getRaftState() != RaftState.Follower) {
                        RaftActor.this.initializeBehavior();
                    }
                }
            }, null, -1L);
        }
    }

    private static final class BehaviorStateTracker {
        private static final BehaviorState NULL_BEHAVIOR_STATE = new BehaviorState(){

            @Override
            RaftActorBehavior getBehavior() {
                return null;
            }

            @Override
            String getLastValidLeaderId() {
                return null;
            }

            @Override
            short getLeaderPayloadVersion() {
                return -1;
            }

            @Override
            String getLastLeaderId() {
                return null;
            }
        };
        private String lastValidLeaderId;
        private String lastLeaderId;

        private BehaviorStateTracker() {
        }

        BehaviorState capture(RaftActorBehavior behavior) {
            if (behavior == null) {
                Verify.verify((this.lastValidLeaderId == null ? 1 : 0) != 0, (String)"Null behavior with non-null last leader", (Object[])new Object[0]);
                return NULL_BEHAVIOR_STATE;
            }
            this.lastLeaderId = behavior.getLeaderId();
            if (this.lastLeaderId != null) {
                this.lastValidLeaderId = this.lastLeaderId;
            }
            return new SimpleBehaviorState(this.lastValidLeaderId, this.lastLeaderId, behavior);
        }
    }

    private static abstract class BehaviorState
    implements Immutable {
        private BehaviorState() {
        }

        abstract @Nullable RaftActorBehavior getBehavior();

        abstract @Nullable String getLastValidLeaderId();

        abstract @Nullable String getLastLeaderId();

        abstract short getLeaderPayloadVersion();
    }

    private static final class SimpleBehaviorState
    extends BehaviorState {
        private final RaftActorBehavior behavior;
        private final String lastValidLeaderId;
        private final String lastLeaderId;
        private final short leaderPayloadVersion;

        SimpleBehaviorState(String lastValidLeaderId, String lastLeaderId, RaftActorBehavior behavior) {
            this.lastValidLeaderId = lastValidLeaderId;
            this.lastLeaderId = lastLeaderId;
            this.behavior = Objects.requireNonNull(behavior);
            this.leaderPayloadVersion = behavior.getLeaderPayloadVersion();
        }

        @Override
        RaftActorBehavior getBehavior() {
            return this.behavior;
        }

        @Override
        String getLastValidLeaderId() {
            return this.lastValidLeaderId;
        }

        @Override
        short getLeaderPayloadVersion() {
            return this.leaderPayloadVersion;
        }

        @Override
        String getLastLeaderId() {
            return this.lastLeaderId;
        }
    }
}

