/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.cluster.Cluster;
import akka.cluster.Member;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.base.messages.ElectionTimeout;
import org.opendaylight.controller.cluster.raft.behaviors.Candidate;
import org.opendaylight.controller.cluster.raft.behaviors.Follower;
import org.opendaylight.controller.cluster.raft.behaviors.IsolatedLeader;
import org.opendaylight.controller.cluster.raft.behaviors.Leader;
import org.opendaylight.controller.cluster.raft.behaviors.PreLeader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.RaftRPC;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import org.opendaylight.controller.cluster.raft.persisted.ApplyJournalEntries;
import org.slf4j.Logger;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public abstract class AbstractRaftActorBehavior
implements RaftActorBehavior {
    protected final RaftActorContext context;
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger log;
    private final String logName;
    private final RaftState state;
    private Cancellable electionCancel = null;
    private long replicatedToAllIndex = -1L;

    AbstractRaftActorBehavior(RaftActorContext context, RaftState state) {
        this.context = Objects.requireNonNull(context);
        this.state = Objects.requireNonNull(state);
        this.log = context.getLogger();
        this.logName = String.format("%s (%s)", new Object[]{context.getId(), state});
    }

    public static RaftActorBehavior createBehavior(RaftActorContext context, RaftState state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case RaftState.Candidate -> new Candidate(context);
            case RaftState.Follower -> new Follower(context);
            case RaftState.IsolatedLeader -> new IsolatedLeader(context);
            case RaftState.Leader -> new Leader(context);
            case RaftState.PreLeader -> new PreLeader(context);
        };
    }

    @Override
    public final RaftState state() {
        return this.state;
    }

    protected final String logName() {
        return this.logName;
    }

    @Override
    public void setReplicatedToAllIndex(long replicatedToAllIndex) {
        this.replicatedToAllIndex = replicatedToAllIndex;
    }

    @Override
    public long getReplicatedToAllIndex() {
        return this.replicatedToAllIndex;
    }

    protected abstract RaftActorBehavior handleAppendEntries(ActorRef var1, AppendEntries var2);

    protected RaftActorBehavior appendEntries(ActorRef sender, AppendEntries appendEntries) {
        if (appendEntries.getTerm() < this.currentTerm()) {
            this.log.info("{}: Cannot append entries because sender's term {} is less than {}", new Object[]{this.logName(), appendEntries.getTerm(), this.currentTerm()});
            sender.tell((Object)new AppendEntriesReply(this.context.getId(), this.currentTerm(), false, this.lastIndex(), this.lastTerm(), this.context.getPayloadVersion(), false, false, appendEntries.getLeaderRaftVersion()), this.actor());
            return this;
        }
        return this.handleAppendEntries(sender, appendEntries);
    }

    protected abstract RaftActorBehavior handleAppendEntriesReply(ActorRef var1, AppendEntriesReply var2);

    protected RaftActorBehavior requestVote(ActorRef sender, RequestVote requestVote) {
        this.log.debug("{}: In requestVote:  {} - currentTerm: {}, votedFor: {}, lastIndex: {}, lastTerm: {}", new Object[]{this.logName(), requestVote, this.currentTerm(), this.votedFor(), this.lastIndex(), this.lastTerm()});
        boolean grantVote = this.canGrantVote(requestVote);
        if (grantVote) {
            this.context.getTermInformation().updateAndPersist(requestVote.getTerm(), requestVote.getCandidateId());
        }
        RequestVoteReply reply = new RequestVoteReply(this.currentTerm(), grantVote);
        this.log.debug("{}: requestVote returning: {}", (Object)this.logName(), (Object)reply);
        sender.tell((Object)reply, this.actor());
        return this;
    }

    protected boolean canGrantVote(RequestVote requestVote) {
        boolean grantVote = false;
        if (requestVote.getTerm() < this.currentTerm()) {
            grantVote = false;
        } else if (this.votedFor() == null || this.votedFor().equals(requestVote.getCandidateId())) {
            boolean candidateLatest = false;
            if (requestVote.getLastLogTerm() > this.lastTerm() || requestVote.getLastLogTerm() == this.lastTerm() && requestVote.getLastLogIndex() >= this.lastIndex()) {
                candidateLatest = true;
            }
            if (candidateLatest) {
                grantVote = true;
            }
        }
        return grantVote;
    }

    protected abstract RaftActorBehavior handleRequestVoteReply(ActorRef var1, RequestVoteReply var2);

    protected FiniteDuration electionDuration() {
        long variance = ThreadLocalRandom.current().nextInt(this.context.getConfigParams().getElectionTimeVariance());
        return this.context.getConfigParams().getElectionTimeOutInterval().$plus(new FiniteDuration(variance, TimeUnit.MILLISECONDS));
    }

    protected void stopElection() {
        if (this.electionCancel != null && !this.electionCancel.isCancelled()) {
            this.electionCancel.cancel();
        }
    }

    protected boolean canStartElection() {
        return this.context.getRaftPolicy().automaticElectionsEnabled() && this.context.isVotingMember();
    }

    protected void scheduleElection(FiniteDuration interval) {
        this.stopElection();
        this.electionCancel = this.context.getActorSystem().scheduler().scheduleOnce(interval, this.context.getActor(), (Object)ElectionTimeout.INSTANCE, (ExecutionContext)this.context.getActorSystem().dispatcher(), this.context.getActor());
    }

    protected long currentTerm() {
        return this.context.getTermInformation().getCurrentTerm();
    }

    protected String votedFor() {
        return this.context.getTermInformation().getVotedFor();
    }

    protected final ActorRef actor() {
        return this.context.getActor();
    }

    protected long lastTerm() {
        return this.context.getReplicatedLog().lastTerm();
    }

    protected long lastIndex() {
        return this.context.getReplicatedLog().lastIndex();
    }

    protected long getLogEntryIndex(long index) {
        ReplicatedLog replLog = this.context.getReplicatedLog();
        if (index == replLog.getSnapshotIndex()) {
            return index;
        }
        ReplicatedLogEntry entry = replLog.get(index);
        return entry != null ? entry.index() : -1L;
    }

    protected long getLogEntryTerm(long index) {
        ReplicatedLog replLog = this.context.getReplicatedLog();
        if (index == replLog.getSnapshotIndex()) {
            return replLog.getSnapshotTerm();
        }
        ReplicatedLogEntry entry = replLog.get(index);
        return entry != null ? entry.term() : -1L;
    }

    protected long getLogEntryOrSnapshotTerm(long index) {
        ReplicatedLog replLog = this.context.getReplicatedLog();
        return replLog.isInSnapshot(index) ? replLog.getSnapshotTerm() : this.getLogEntryTerm(index);
    }

    protected void applyLogToStateMachine(long index) {
        for (long i = this.context.getLastApplied() + 1L; i < index + 1L; ++i) {
            ReplicatedLogEntry replicatedLogEntry = this.context.getReplicatedLog().get(i);
            if (replicatedLogEntry == null) {
                this.log.warn("{}: Missing index {} from log. Cannot apply state. Ignoring {} to {}", new Object[]{this.logName(), i, i, index});
                break;
            }
            ApplyState applyState = this.getApplyStateFor(replicatedLogEntry);
            this.log.debug("{}: Setting last applied to {}", (Object)this.logName(), (Object)i);
            this.context.setLastApplied(i);
            this.context.getApplyStateConsumer().accept(applyState);
        }
        this.actor().tell((Object)new ApplyJournalEntries(this.context.getLastApplied()), this.actor());
    }

    abstract ApplyState getApplyStateFor(ReplicatedLogEntry var1);

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        Object object = message;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AppendEntries.class, AppendEntriesReply.class, RequestVote.class, RequestVoteReply.class}, (Object)object2, n)) {
            case 0 -> {
                AppendEntries appendEntries = (AppendEntries)object2;
                yield this.appendEntries(sender, appendEntries);
            }
            case 1 -> {
                AppendEntriesReply appendEntriesReply = (AppendEntriesReply)object2;
                yield this.handleAppendEntriesReply(sender, appendEntriesReply);
            }
            case 2 -> {
                RequestVote requestVote = (RequestVote)object2;
                yield this.requestVote(sender, requestVote);
            }
            case 3 -> {
                RequestVoteReply requestVoteReply = (RequestVoteReply)object2;
                yield this.handleRequestVoteReply(sender, requestVoteReply);
            }
            default -> null;
        };
    }

    @Override
    public RaftActorBehavior switchBehavior(RaftActorBehavior behavior) {
        return this.internalSwitchBehavior(behavior);
    }

    protected RaftActorBehavior internalSwitchBehavior(RaftState newState) {
        return this.internalSwitchBehavior(AbstractRaftActorBehavior.createBehavior(this.context, newState));
    }

    protected RaftActorBehavior internalSwitchBehavior(RaftActorBehavior newBehavior) {
        if (!this.context.getRaftPolicy().automaticElectionsEnabled()) {
            return this;
        }
        this.log.info("{} :- Switching from behavior {} to {}, election term: {}", new Object[]{this.logName(), this.state(), newBehavior.state(), this.context.getTermInformation().getCurrentTerm()});
        try {
            this.close();
        }
        catch (RuntimeException e) {
            this.log.error("{}: Failed to close behavior : {}", new Object[]{this.logName(), this.state(), e});
        }
        return newBehavior;
    }

    protected int getMajorityVoteCount(int numPeers) {
        int numMajority = 0;
        if (numPeers > 0) {
            int self = 1;
            numMajority = (numPeers + self) / 2 + 1;
        }
        return numMajority;
    }

    protected void performSnapshotWithoutCapture(long snapshotCapturedIndex) {
        long actualIndex = this.context.getSnapshotManager().trimLog(snapshotCapturedIndex);
        if (actualIndex != -1L) {
            this.setReplicatedToAllIndex(actualIndex);
        }
    }

    protected final String getId() {
        return this.context.getId();
    }

    protected boolean shouldUpdateTerm(RaftRPC rpc) {
        if (!(rpc instanceof RequestVote)) {
            return true;
        }
        RequestVote requestVote = (RequestVote)rpc;
        this.log.debug("{}: Found higher term in RequestVote rpc, verifying whether it's safe to update term.", (Object)this.logName());
        Optional<Cluster> maybeCluster = this.context.getCluster();
        if (!maybeCluster.isPresent()) {
            return true;
        }
        Cluster cluster = maybeCluster.orElseThrow();
        Set unreachable = cluster.state().getUnreachable();
        this.log.debug("{}: Cluster state: {}", (Object)this.logName(), (Object)unreachable);
        for (Member member : unreachable) {
            for (String role : member.getRoles()) {
                if (!requestVote.getCandidateId().startsWith(role)) continue;
                this.log.debug("{}: Unreachable member: {}, matches candidateId in: {}, not updating term", new Object[]{this.logName(), member, requestVote});
                return false;
            }
        }
        this.log.debug("{}: Candidate in requestVote:{} with higher term appears reachable, updating term.", (Object)this.logName(), (Object)requestVote);
        return true;
    }
}

