/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class LE
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long index;
    private long term;
    private Payload data;

    public LE() {
    }

    LE(Void dummy) {
        this.index = Long.MIN_VALUE;
        this.term = Long.MIN_VALUE;
        this.data = null;
    }

    LE(SimpleReplicatedLogEntry logEntry) {
        this.index = logEntry.index();
        this.term = logEntry.term();
        this.data = logEntry.getData();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WritableObjects.writeLongs((DataOutput)out, (long)this.index, (long)this.term);
        out.writeObject(this.data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        this.index = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        this.term = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        this.data = (Payload)in.readObject();
    }

    private Object readResolve() {
        return new SimpleReplicatedLogEntry(this.index, this.term, this.data);
    }
}

