/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Serializable;
import java.util.List;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.persisted.SS;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;

public final class Snapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final State state;
    private final List<ReplicatedLogEntry> unAppliedEntries;
    private final long lastIndex;
    private final long lastTerm;
    private final long lastAppliedIndex;
    private final long lastAppliedTerm;
    private final long electionTerm;
    private final String electionVotedFor;
    private final ServerConfigurationPayload serverConfig;

    private Snapshot(State state, List<ReplicatedLogEntry> unAppliedEntries, long lastIndex, long lastTerm, long lastAppliedIndex, long lastAppliedTerm, long electionTerm, String electionVotedFor, ServerConfigurationPayload serverConfig) {
        this.state = state;
        this.unAppliedEntries = unAppliedEntries;
        this.lastIndex = lastIndex;
        this.lastTerm = lastTerm;
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
        this.electionTerm = electionTerm;
        this.electionVotedFor = electionVotedFor;
        this.serverConfig = serverConfig;
    }

    public static Snapshot create(State state, List<ReplicatedLogEntry> entries, long lastIndex, long lastTerm, long lastAppliedIndex, long lastAppliedTerm, long electionTerm, String electionVotedFor, ServerConfigurationPayload serverConfig) {
        return new Snapshot(state, entries, lastIndex, lastTerm, lastAppliedIndex, lastAppliedTerm, electionTerm, electionVotedFor, serverConfig);
    }

    public State getState() {
        return this.state;
    }

    public List<ReplicatedLogEntry> getUnAppliedEntries() {
        return this.unAppliedEntries;
    }

    public long getLastTerm() {
        return this.lastTerm;
    }

    public long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public long getLastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public long getElectionTerm() {
        return this.electionTerm;
    }

    public String getElectionVotedFor() {
        return this.electionVotedFor;
    }

    public ServerConfigurationPayload getServerConfiguration() {
        return this.serverConfig;
    }

    public String toString() {
        return "Snapshot [lastIndex=" + this.lastIndex + ", lastTerm=" + this.lastTerm + ", lastAppliedIndex=" + this.lastAppliedIndex + ", lastAppliedTerm=" + this.lastAppliedTerm + ", unAppliedEntries size=" + this.unAppliedEntries.size() + ", state=" + String.valueOf(this.state) + ", electionTerm=" + this.electionTerm + ", electionVotedFor=" + this.electionVotedFor + ", ServerConfigPayload=" + String.valueOf(this.serverConfig) + "]";
    }

    private Object writeReplace() {
        return new SS(this);
    }

    public static interface State
    extends Serializable {
        default public boolean needsMigration() {
            return false;
        }
    }
}

