/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionAdapterFilter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;

@NonNullByDefault
final class ActionServiceAdapter
extends AbstractBindingLoadingAdapter<DOMActionService, ActionSpec<?, ?>, ActionAdapter>
implements ActionService {
    static final BindingDOMAdapterBuilder.Factory<ActionService> BUILDER_FACTORY = Builder::new;

    ActionServiceAdapter(AdapterContext adapterContext, DOMActionService delegate) {
        super(adapterContext, delegate);
    }

    public <P extends DataObject, A extends Action<? extends DataObjectIdentifier<P>, ?, ?>> A getActionHandle(ActionSpec<A, P> spec, Set<DataTreeIdentifier<P>> nodes) {
        Class type = spec.type();
        ActionAdapter adapter = (ActionAdapter)this.getAdapter(spec);
        return (A)((Action)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, nodes.isEmpty() ? adapter : new ActionAdapterFilter(adapter, Set.copyOf(nodes)))));
    }

    @Override
    ActionAdapter loadAdapter(ActionSpec<?, ?> key) {
        Class type = key.type();
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass((Class)type));
        Preconditions.checkArgument((boolean)type.isInterface(), (Object)"Supplied Action type must be an interface.");
        return new ActionAdapter(this.adapterContext(), (DOMActionService)this.getDelegate(), key);
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<? extends Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionService.class);
        }

        @Override
        protected ActionService createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new ActionServiceAdapter(this.adapterContext(), (DOMActionService)delegates.getInstance(DOMActionService.class));
        }
    }
}

