/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.InstanceNotificationPublishService;
import org.opendaylight.mdsal.binding.api.InstanceNotificationService;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.binding.dom.adapter.ActionProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterLoader;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.InstanceNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.InstanceNotificationServiceAdapter;
import org.opendaylight.mdsal.dom.api.DOMService;

public abstract class BindingDOMAdapterLoader
extends AdapterLoader<BindingService, DOMService<?, ?>> {
    private static final ImmutableMap<Class<?>, BindingDOMAdapterBuilder.Factory<?>> FACTORIES = ImmutableMap.builder().put(NotificationService.class, BindingDOMNotificationServiceAdapter.BUILDER_FACTORY).put(NotificationPublishService.class, BindingDOMNotificationPublishServiceAdapter.BUILDER_FACTORY).put(DataBroker.class, BindingDOMDataBrokerAdapter.BUILDER_FACTORY).put(RpcService.class, BindingDOMRpcServiceAdapter.BUILDER_FACTORY).put(ActionService.class, ActionServiceAdapter.BUILDER_FACTORY).put(ActionProviderService.class, ActionProviderServiceAdapter.BUILDER_FACTORY).put(InstanceNotificationService.class, InstanceNotificationServiceAdapter.BUILDER_FACTORY).put(InstanceNotificationPublishService.class, InstanceNotificationPublishServiceAdapter.BUILDER_FACTORY).build();
    private final AdapterContext codec;

    protected BindingDOMAdapterLoader(AdapterContext codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    @Override
    protected final AdapterBuilder<? extends BindingService, DOMService<?, ?>> createBuilder(Class<? extends BindingService> key) {
        BindingDOMAdapterBuilder.Factory factory = (BindingDOMAdapterBuilder.Factory)FACTORIES.get(key);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"Unsupported service type %s", key);
        return factory.newBuilder(this.codec);
    }
}

