/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeService;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMTransactionChainAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;

@VisibleForTesting
public class BindingDOMDataBrokerAdapter
extends AbstractBindingAdapter<DOMDataBroker>
implements DataBroker {
    static final BindingDOMAdapterBuilder.Factory<DataBroker> BUILDER_FACTORY = Builder::new;
    private final DataTreeChangeService treeChangeService;

    public BindingDOMDataBrokerAdapter(AdapterContext adapterContext, DOMDataBroker domDataBroker) {
        super(adapterContext, domDataBroker);
        DOMDataBroker.DataTreeChangeExtension domTreeChange = (DOMDataBroker.DataTreeChangeExtension)domDataBroker.extension(DOMDataBroker.DataTreeChangeExtension.class);
        this.treeChangeService = domTreeChange == null ? null : new BindingDOMDataTreeChangeServiceAdapter(adapterContext, domTreeChange);
    }

    public ReadTransaction newReadOnlyTransaction() {
        return new BindingDOMReadTransactionAdapter(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newReadOnlyTransaction());
    }

    public WriteTransaction newWriteOnlyTransaction() {
        return new BindingDOMWriteTransactionAdapter<DOMDataTreeWriteTransaction>(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newWriteOnlyTransaction());
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        return new BindingDOMReadWriteTransactionAdapter(this.adapterContext(), ((DOMDataBroker)this.getDelegate()).newReadWriteTransaction());
    }

    public TransactionChain createTransactionChain() {
        return new BindingDOMTransactionChainAdapter(((DOMDataBroker)this.getDelegate()).createTransactionChain(), this.adapterContext());
    }

    public TransactionChain createMergingTransactionChain() {
        return new BindingDOMTransactionChainAdapter(((DOMDataBroker)this.getDelegate()).createMergingTransactionChain(), this.adapterContext());
    }

    public <T extends DataObject> Registration registerTreeChangeListener(LogicalDatastoreType datastore, DataObjectReference<T> subtrees, DataTreeChangeListener<T> listener) {
        return this.getTreeChangeService().registerTreeChangeListener(datastore, subtrees, listener);
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public <T extends DataObject> Registration registerLegacyTreeChangeListener(LogicalDatastoreType datastore, DataObjectReference<T> subtrees, DataTreeChangeListener<T> listener) {
        return this.getTreeChangeService().registerLegacyTreeChangeListener(datastore, subtrees, listener);
    }

    private @NonNull DataTreeChangeService getTreeChangeService() {
        DataTreeChangeService local = this.treeChangeService;
        if (local == null) {
            throw new UnsupportedOperationException("Underlying data broker does not expose DOMDataTreeChangeService.");
        }
        return local;
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<DataBroker> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<? extends Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMDataBroker.class);
        }

        @Override
        protected DataBroker createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new BindingDOMDataBrokerAdapter(this.adapterContext(), (DOMDataBroker)delegates.getInstance(DOMDataBroker.class));
        }
    }
}

