/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class BindingDOMDataChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataChangeListener<T> listener;

    BindingDOMDataChangeListenerAdapter(AdapterContext adapterContext, DataChangeListener<T> listener) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
    }

    public void onDataTreeChanged(List<DataTreeCandidate> changes) {
        DataTreeCandidate first = changes.get(0);
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(serializer.coerceInstanceIdentifier(first.getRootPath()));
        this.listener.dataChanged(this.deserialize(codec, first.getRootNode().dataBefore()), this.deserialize(codec, changes.get(changes.size() - 1).getRootNode().dataAfter()));
    }

    public void onInitialData() {
        this.listener.dataChanged(null, null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listener", this.listener).toString();
    }

    private @Nullable T deserialize(CommonDataObjectCodecTreeNode<?> codec, NormalizedNode data) {
        if (data == null) {
            return null;
        }
        CommonDataObjectCodecTreeNode<?> commonDataObjectCodecTreeNode = codec;
        Objects.requireNonNull(commonDataObjectCodecTreeNode);
        CommonDataObjectCodecTreeNode<?> commonDataObjectCodecTreeNode2 = commonDataObjectCodecTreeNode;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BindingDataObjectCodecTreeNode.class, BindingAugmentationCodecTreeNode.class}, commonDataObjectCodecTreeNode2, n)) {
            case 0 -> {
                BindingDataObjectCodecTreeNode dataObject = (BindingDataObjectCodecTreeNode)commonDataObjectCodecTreeNode2;
                yield (DataObject)dataObject.deserialize(data);
            }
            case 1 -> {
                BindingAugmentationCodecTreeNode augmentation = (BindingAugmentationCodecTreeNode)commonDataObjectCodecTreeNode2;
                yield augmentation.filterFrom(data);
            }
            default -> throw new IllegalStateException("Unhandled codec " + String.valueOf(codec));
        });
    }
}

