/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

@NonNullByDefault
final class BindingDOMDataTreeChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataTreeChangeListener<T> listener;
    private final LogicalDatastoreType store;
    private final @Nullable Class<? extends Augmentation<?>> augment;
    private boolean initialSyncDone;

    BindingDOMDataTreeChangeListenerAdapter(AdapterContext adapterContext, LogicalDatastoreType store, DataObjectReference<T> treeId, DataTreeChangeListener<T> listener) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
        this.store = Objects.requireNonNull(store);
        this.augment = BindingDOMDataTreeChangeListenerAdapter.extractAugment(treeId.lastStep().type());
    }

    private static @Nullable Class<? extends Augmentation<?>> extractAugment(Class<?> target) {
        return Augmentation.class.isAssignableFrom(target) ? target.asSubclass(Augmentation.class) : null;
    }

    public void onDataTreeChanged(List<DataTreeCandidate> domChanges) {
        List changes = LazyDataTreeModification.from(this.adapterContext.currentSerializer(), domChanges, this.store, this.augment);
        if (!changes.isEmpty()) {
            this.listener.onDataTreeChanged(changes);
        } else if (!this.initialSyncDone) {
            this.onInitialData();
        }
    }

    public void onInitialData() {
        this.initialSyncDone = true;
        this.listener.onInitialData();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listener", this.listener).toString();
    }
}

