/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.MountPoint;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingMountPointAdapter;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingDOMMountPointListenerAdapter
implements Registration,
DOMMountPointListener {
    private static final Logger LOG = LoggerFactory.getLogger(BindingDOMMountPointListenerAdapter.class);
    @VisibleForTesting
    final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull MountPointService.MountPointListener listener;
    private final BindingDOMMountPointServiceAdapter service;
    private final Registration registration;

    BindingDOMMountPointListenerAdapter(BindingDOMMountPointServiceAdapter service, MountPointService.MountPointListener listener) {
        this.service = Objects.requireNonNull(service);
        this.listener = Objects.requireNonNull(listener);
        this.registration = ((DOMMountPointService)service.getDelegate()).registerProvisionListener((DOMMountPointListener)this);
    }

    public void close() {
        this.registration.close();
    }

    public void onMountPointCreated(DOMMountPoint mountPoint) {
        BindingMountPointAdapter binding;
        try {
            binding = (BindingMountPointAdapter)this.service.getAdapter(mountPoint);
        }
        catch (UncheckedExecutionException e) {
            LOG.error("Unable to translate mountPoint {}. Omitting event.", (Object)mountPoint, (Object)e);
            return;
        }
        this.listener.onMountPointCreated((MountPoint)binding);
    }

    public void onMountPointRemoved(YangInstanceIdentifier path) {
        DataObjectIdentifier<?> binding;
        try {
            binding = this.toBinding(path);
        }
        catch (DeserializationException e) {
            LOG.error("Unable to translate mountPoint path {}. Omitting event.", (Object)path, (Object)e);
            return;
        }
        this.listener.onMountPointRemoved(binding);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listener", (Object)this.listener).toString();
    }

    private @NonNull DataObjectIdentifier<?> toBinding(YangInstanceIdentifier path) throws DeserializationException {
        DataObjectReference binding;
        try {
            binding = this.service.currentSerializer().fromYangInstanceIdentifier(path);
        }
        catch (IllegalArgumentException e) {
            throw new DeserializationException("Deserialization unsuccessful, " + String.valueOf(path), (Throwable)e);
        }
        if (binding == null) {
            throw new DeserializationException("Deserialization unsuccessful, " + String.valueOf(path));
        }
        try {
            return binding.toIdentifier();
        }
        catch (UnsupportedOperationException e) {
            throw new DeserializationException((Throwable)e);
        }
    }
}

