/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.annotations.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract sealed class ContextReferenceExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ContextReferenceExtractor.class);

    ContextReferenceExtractor() {
    }

    static @Nullable ContextReferenceExtractor of(Class<?> type) {
        Method contextGetter = ContextReferenceExtractor.getContextGetter(type);
        if (contextGetter == null) {
            return null;
        }
        Class<?> returnType = contextGetter.getReturnType();
        try {
            if (BindingInstanceIdentifier.class.isAssignableFrom(returnType)) {
                return Direct.create(contextGetter);
            }
            Method getValueMethod = ContextReferenceExtractor.findGetValueMethod(returnType, BindingInstanceIdentifier.class);
            if (getValueMethod != null) {
                return GetValue.create(contextGetter, getValueMethod);
            }
            LOG.warn("Class {} can not be used to determine context, falling back to NULL_EXTRACTOR.", returnType);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Class {} does not conform to Binding Specification v1. Falling back to NULL_EXTRACTOR", returnType, (Object)e);
        }
        return null;
    }

    final @Nullable BindingInstanceIdentifier extract(DataObject obj) {
        try {
            return this.extractImpl(obj);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    abstract @Nullable BindingInstanceIdentifier extractImpl(DataObject var1) throws Throwable;

    private static @Nullable Method findGetValueMethod(Class<?> type, Class<?> returnType) {
        Method method;
        try {
            method = type.getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Value class {} does not comform to Binding Specification v1.", type, (Object)e);
            return null;
        }
        if (returnType.equals(method.getReturnType())) {
            return method;
        }
        return null;
    }

    private static Method getContextGetter(Class<?> type) {
        for (Method method : type.getMethods()) {
            if (method.getAnnotation(RoutingContext.class) == null) continue;
            return method;
        }
        return null;
    }

    @VisibleForTesting
    static final class Direct
    extends ContextReferenceExtractor {
        private final MethodHandle handle;

        private Direct(MethodHandle rawHandle) {
            this.handle = rawHandle.asType(MethodType.methodType(BindingInstanceIdentifier.class, DataObject.class));
        }

        @VisibleForTesting
        static ContextReferenceExtractor create(Method getterMethod) throws IllegalAccessException {
            return new Direct(MethodHandles.publicLookup().unreflect(getterMethod));
        }

        @Override
        BindingInstanceIdentifier extractImpl(DataObject obj) throws Throwable {
            return this.handle.invokeExact(obj);
        }
    }

    @VisibleForTesting
    static final class GetValue
    extends ContextReferenceExtractor {
        private final MethodHandle contextHandle;
        private final MethodHandle valueHandle;

        private GetValue(MethodHandle rawContextHandle, MethodHandle rawValueHandle) {
            this.contextHandle = rawContextHandle.asType(MethodType.methodType(Object.class, DataObject.class));
            this.valueHandle = rawValueHandle.asType(MethodType.methodType(BindingInstanceIdentifier.class, Object.class));
        }

        private static ContextReferenceExtractor create(Method contextGetter, Method getValueMethod) throws IllegalAccessException {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            return new GetValue(lookup.unreflect(contextGetter), lookup.unreflect(getValueMethod));
        }

        @Override
        BindingInstanceIdentifier extractImpl(DataObject obj) throws Throwable {
            Object ctx = this.contextHandle.invokeExact(obj);
            return ctx == null ? null : this.valueHandle.invokeExact(ctx);
        }
    }
}

