/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.dom.api.DOMRpcException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DefaultDOMRpcException;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

final class LazyDOMRpcResultFuture
extends AbstractFuture<DOMRpcResult>
implements BindingRpcFutureAware {
    private static final ExceptionMapper<DOMRpcException> DOM_RPC_EX_MAPPER = new ExceptionMapper<DOMRpcException>("rpc", DOMRpcException.class){

        protected DOMRpcException newWithCause(String message, Throwable cause) {
            return cause instanceof DOMRpcException ? (DOMRpcException)cause : new DefaultDOMRpcException("RPC failed", cause);
        }
    };
    private final ListenableFuture<RpcResult<?>> bindingFuture;
    private final BindingNormalizedNodeSerializer codec;
    private volatile DOMRpcResult result;

    private LazyDOMRpcResultFuture(ListenableFuture<RpcResult<?>> delegate, BindingNormalizedNodeSerializer codec) {
        this.bindingFuture = Objects.requireNonNull(delegate, "delegate");
        this.codec = Objects.requireNonNull(codec, "codec");
    }

    static @NonNull LazyDOMRpcResultFuture create(BindingNormalizedNodeSerializer codec, ListenableFuture<RpcResult<?>> bindingResult) {
        return new LazyDOMRpcResultFuture(bindingResult, codec);
    }

    @Override
    public ListenableFuture<RpcResult<?>> getBindingFuture() {
        return this.bindingFuture;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.bindingFuture.cancel(mayInterruptIfRunning);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.bindingFuture.addListener(listener, executor);
    }

    public DOMRpcResult get() throws InterruptedException, ExecutionException {
        if (this.result != null) {
            return this.result;
        }
        try {
            return this.transformIfNecessary((RpcResult)this.bindingFuture.get());
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e.getMessage(), DOM_RPC_EX_MAPPER.apply((Exception)e));
        }
    }

    public DOMRpcResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result != null) {
            return this.result;
        }
        try {
            return this.transformIfNecessary((RpcResult)this.bindingFuture.get(timeout, unit));
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e.getMessage(), DOM_RPC_EX_MAPPER.apply((Exception)e));
        }
    }

    public boolean isCancelled() {
        return this.bindingFuture.isCancelled();
    }

    public boolean isDone() {
        return this.bindingFuture.isDone();
    }

    private synchronized DOMRpcResult transformIfNecessary(RpcResult<?> input) {
        if (this.result == null) {
            this.result = this.transform(input);
        }
        return this.result;
    }

    private DOMRpcResult transform(RpcResult<?> input) {
        if (input.isSuccessful()) {
            ContainerNode containerNode;
            Object object = input.getResult();
            if (object instanceof DataContainer) {
                DataContainer container = (DataContainer)object;
                containerNode = this.codec.toNormalizedNodeRpcData(container);
            } else {
                containerNode = null;
            }
            ContainerNode value = containerNode;
            return new DefaultDOMRpcResult(value);
        }
        return new DefaultDOMRpcResult((Collection)input.getErrors());
    }
}

