/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.base.MoreObjects;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdaptingTracker<D extends DOMService<?, ?>, B extends BindingService>
extends ServiceTracker<D, AdaptedService<B>> {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptingTracker.class);
    private final Function<D, B> bindingFactory;
    private final @NonNull Class<B> bindingClass;
    private final ComponentFactory<? extends B> componentFactory;

    AdaptingTracker(BundleContext ctx, Class<D> domClass, Class<B> bindingClass, Function<D, B> bindingFactory, ComponentFactory<? extends B> componentFactory) {
        super(ctx, domClass, null);
        this.bindingClass = Objects.requireNonNull(bindingClass);
        this.bindingFactory = Objects.requireNonNull(bindingFactory);
        this.componentFactory = Objects.requireNonNull(componentFactory);
    }

    public void open(boolean trackAllServices) {
        LOG.debug("Starting tracker for {}", (Object)this.bindingClass.getName());
        super.open(trackAllServices);
        LOG.debug("Tracker for {} started", (Object)this.bindingClass.getName());
    }

    public void close() {
        LOG.debug("Stopping tracker for {}", (Object)this.bindingClass.getName());
        super.close();
        LOG.debug("Tracker for {} stopped", (Object)this.bindingClass.getName());
    }

    public AdaptedService<B> addingService(ServiceReference<D> reference) {
        if (reference == null) {
            LOG.debug("Null reference for {}, ignoring it", (Object)this.bindingClass.getName());
            return null;
        }
        if (reference.getProperty("odl.mdsal.binding.adapter.ignore") != null) {
            LOG.debug("Ignoring reference {} due to {}", reference, (Object)"odl.mdsal.binding.adapter.ignore");
            return null;
        }
        DOMService dom = (DOMService)this.context.getService(reference);
        if (dom == null) {
            LOG.debug("Could not get {} service from {}, ignoring it", (Object)this.bindingClass.getName(), reference);
            return null;
        }
        BindingService binding = (BindingService)this.bindingFactory.apply(dom);
        AdaptedService<BindingService> service = new AdaptedService<BindingService>(binding, this.componentFactory.newInstance(AdaptingTracker.referenceProperties(reference, binding)));
        LOG.debug("Registered {}", service);
        return service;
    }

    public void modifiedService(ServiceReference<D> reference, AdaptedService<B> service) {
        if (service != null && reference != null) {
            LOG.debug("Restarting {}", service);
            service.component.dispose();
            service.component = this.componentFactory.newInstance(AdaptingTracker.referenceProperties(reference, service.delegate));
            LOG.debug("Restarted {}", service);
        }
    }

    public void removedService(ServiceReference<D> reference, AdaptedService<B> service) {
        if (service != null) {
            service.component.dispose();
            this.context.ungetService(reference);
            LOG.debug("Unregistered {}", service);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("bindingClass", (Object)this.bindingClass.getName()).toString();
    }

    static Dictionary<String, Object> referenceProperties(ServiceReference<?> ref, BindingService service) {
        Object value;
        String[] keys = ref.getPropertyKeys();
        HashMap<String, Object> props = HashMap.newHashMap(keys.length + 1);
        for (String key : keys) {
            if (key.startsWith("odl.mdsal.binding.adapter.") || (value = ref.getProperty(key)) == null) continue;
            props.put(key, value);
        }
        for (String key : keys) {
            String newKey;
            if (!key.startsWith("odl.mdsal.binding.adapter.override.") || (value = ref.getProperty(key)) == null || (newKey = key.substring("odl.mdsal.binding.adapter.override.".length())).isEmpty()) continue;
            LOG.debug("Overriding property {}", (Object)newKey);
            props.put(newKey, value);
        }
        props.put("org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE", service);
        return FrameworkUtil.asDictionary(props);
    }

    static final class AdaptedService<B extends BindingService> {
        private final B delegate;
        private ComponentInstance<? extends B> component;

        private AdaptedService(B delegate, ComponentInstance<? extends B> component) {
            this.delegate = (BindingService)Objects.requireNonNull(delegate);
            this.component = Objects.requireNonNull(component);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("delegate", this.delegate).toString();
        }
    }
}

