/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractEffectiveUnknownSchmemaNode;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;

@Beta
final class YangDataEffectiveStatementImpl
extends AbstractEffectiveUnknownSchmemaNode<YangDataName, YangDataStatement>
implements YangDataEffectiveStatement,
YangDataSchemaNode,
EffectiveStatementMixins.DataNodeContainerMixin<YangDataName, YangDataStatement> {
    private final @NonNull DataSchemaNode child;

    YangDataEffectiveStatementImpl(EffectiveStmtCtx.Current<YangDataName, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, DataSchemaNode child) {
        super((UnknownStatement)((YangDataStatement)stmt.declared()), (Object)((YangDataName)stmt.argument()), (CopyableNode)stmt.history(), substatements);
        this.child = Objects.requireNonNull(child);
    }

    public QName getQName() {
        return this.child.getQName();
    }

    public DataSchemaNode dataChildByName(QName name) {
        return name.equals((Object)this.child.getQName()) ? this.child : null;
    }

    public YangDataEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public Optional<DataTreeEffectiveStatement<?>> findDataTreeNode(QName qname) {
        DataTreeEffectiveStatement dataChild;
        DataSchemaNode dataSchemaNode = this.child;
        if (dataSchemaNode instanceof DataTreeEffectiveStatement && ((QName)(dataChild = (DataTreeEffectiveStatement)dataSchemaNode).argument()).equals((Object)qname)) {
            return Optional.of(dataChild);
        }
        dataSchemaNode = this.child;
        if (dataSchemaNode instanceof DataTreeAwareEffectiveStatement) {
            DataTreeAwareEffectiveStatement aware = (DataTreeAwareEffectiveStatement)dataSchemaNode;
            return aware.findDataTreeNode(qname);
        }
        throw new VerifyException("Unexpected child " + String.valueOf(this.child));
    }

    public Collection<DataTreeEffectiveStatement<?>> dataTreeNodes() {
        DataSchemaNode dataSchemaNode = this.child;
        if (dataSchemaNode instanceof DataTreeEffectiveStatement) {
            DataTreeEffectiveStatement dataChild = (DataTreeEffectiveStatement)dataSchemaNode;
            return List.of(dataChild);
        }
        dataSchemaNode = this.child;
        if (dataSchemaNode instanceof DataTreeAwareEffectiveStatement) {
            DataTreeAwareEffectiveStatement aware = (DataTreeAwareEffectiveStatement)dataSchemaNode;
            return aware.dataTreeNodes();
        }
        throw new VerifyException("Unexpected child " + String.valueOf(this.child));
    }

    public Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
        return List.of(this.child);
    }

    public Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName qname) {
        return qname.equals((Object)this.child.getQName()) ? Optional.of(this.child) : Optional.empty();
    }
}

