/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataConstants;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatements;
import org.opendaylight.yangtools.rfc8040.parser.OperationsValidateModuleAction;
import org.opendaylight.yangtools.rfc8040.parser.RefYangDataStatement;
import org.opendaylight.yangtools.rfc8040.parser.YangDataEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8040.parser.YangDataStatementImpl;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class YangDataStatementSupport
extends AbstractStatementSupport<YangDataName, YangDataStatement, YangDataEffectiveStatement> {
    private static final @NonNull ParserNamespace<YangDataName, StmtContext<YangDataName, YangDataStatement, YangDataEffectiveStatement>> NAMESPACE = new ParserNamespace("yang-data");
    public static final @NonNull NamespaceBehaviour<YangDataName, StmtContext<YangDataName, YangDataStatement, YangDataEffectiveStatement>> BEHAVIOUR = NamespaceBehaviour.global(NAMESPACE);
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangDataStatements.YANG_DATA).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.USES).build();
    @VisibleForTesting
    static final YangDataName YANG_API = new YangDataName(YangDataConstants.RFC8040_MODULE, "yang-api");

    public YangDataStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangDataStatements.YANG_DATA, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public YangDataName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return new YangDataName(StmtContextUtils.getModuleQName((RootStmtContext)ctx.getRoot()), value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid yang-data argument %s", new Object[]{value});
        }
    }

    public void onStatementAdded(StmtContext.Mutable<YangDataName, YangDataStatement, YangDataEffectiveStatement> stmt) {
        StmtContext.Mutable parent = stmt.coerceParentContext();
        if (parent.getParentContext() != null) {
            stmt.setUnsupported();
            return;
        }
        YangDataName name = (YangDataName)stmt.argument();
        StmtContext prev = (StmtContext)parent.namespaceItem(NAMESPACE, (Object)name);
        if (prev != null) {
            throw new SourceException(stmt, "Error in module '%s': cannot add '%s'. Node name collision: '%s' already declared at %s", new Object[]{stmt.getRoot().rawArgument(), name, prev.argument(), prev.sourceReference()});
        }
        parent.addToNs(NAMESPACE, (Object)((YangDataName)stmt.argument()), stmt);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<YangDataName, YangDataStatement, YangDataEffectiveStatement> ctx) {
        StmtContext stmt;
        Collection stmts;
        if (!ctx.isSupportedToBuildEffective()) {
            return;
        }
        super.onFullDefinitionDeclared(ctx);
        if (YANG_API.equals(ctx.getArgument()) && (stmts = ctx.declaredSubstatements()).size() == 1 && (stmt = (StmtContext)stmts.iterator().next()).producesEffective(UsesEffectiveStatement.class) && "restconf".equals(stmt.rawArgument())) {
            OperationsValidateModuleAction.applyTo(ctx.coerceParentContext());
        }
    }

    public boolean isIgnoringIfFeatures() {
        return true;
    }

    public boolean isIgnoringConfig() {
        return true;
    }

    protected YangDataStatement createDeclared(BoundStmtCtx<YangDataName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new YangDataStatementImpl((YangDataName)ctx.getArgument(), substatements);
    }

    protected YangDataStatement attachDeclarationReference(YangDataStatement stmt, DeclarationReference reference) {
        return new RefYangDataStatement(stmt, reference);
    }

    protected YangDataEffectiveStatement createEffective(EffectiveStmtCtx.Current<YangDataName, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        List schemaSub = substatements.stream().filter(SchemaTreeEffectiveStatement.class::isInstance).map(SchemaTreeEffectiveStatement.class::cast).collect(Collectors.toUnmodifiableList());
        DataSchemaNode child = switch (schemaSub.size()) {
            case 0 -> throw new MissingSubstatementException(stmt, "yang-data requires at least one substatement", new Object[0]);
            case 1 -> {
                SchemaTreeEffectiveStatement substmt = (SchemaTreeEffectiveStatement)schemaSub.getFirst();
                SourceException.throwIf((!(substmt instanceof ChoiceEffectiveStatement) && !(substmt instanceof DataTreeEffectiveStatement) ? 1 : 0) != 0, stmt, (String)"%s is not a recognized container data node definition", (Object[])new Object[]{substmt});
                if (substmt instanceof DataSchemaNode) {
                    yield (DataSchemaNode)substmt;
                }
                throw new VerifyException("Unexpected single child " + String.valueOf(substmt));
            }
            default -> throw new InvalidSubstatementException(stmt, "yang-data requires exactly one container data node definition, found %s", new Object[]{schemaSub});
        };
        return new YangDataEffectiveStatementImpl(stmt, substatements, child);
    }
}

