/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import tech.pantheon.triemap.Branch;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.DefaultEntry;
import tech.pantheon.triemap.EntryNode;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.LNodeEntries;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final Branch<K, V>[][] nodeStack = new Branch[7][];
    private final int[] positionStack = new int[7];
    private final ImmutableTrieMap<K, V> map;
    private LNodeEntries<K, V> lnode;
    private EntryNode<K, V> current;
    private int depth = -1;

    AbstractIterator(ImmutableTrieMap<K, V> map) {
        this.map = Objects.requireNonNull(map);
        this.readin(map.readRoot());
    }

    @Override
    public final boolean hasNext() {
        return this.current != null || this.lnode != null;
    }

    @Override
    public final Map.Entry<K, V> next() {
        DefaultEntry<K, V> entry;
        if (this.lnode != null) {
            entry = this.lnode;
            this.lnode = this.lnode.next();
            if (this.lnode == null) {
                this.advance();
            }
        } else {
            entry = this.current;
            this.advance();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return this.wrapEntry(entry);
    }

    abstract Map.Entry<K, V> wrapEntry(DefaultEntry<K, V> var1);

    private void readin(INode<K, V> in) {
        MainNode<K, V> m = in.gcasRead(this.map);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            ++this.depth;
            this.nodeStack[this.depth] = cn.array;
            this.positionStack[this.depth] = -1;
            this.advance();
        } else if (m instanceof TNode) {
            TNode tn;
            this.current = tn = (TNode)m;
        } else if (m instanceof LNode) {
            LNode ln = (LNode)m;
            this.lnode = ln.entries;
        } else if (m == null) {
            this.current = null;
        }
    }

    private void advance() {
        if (this.depth >= 0) {
            int npos = this.positionStack[this.depth] + 1;
            if (npos < this.nodeStack[this.depth].length) {
                this.positionStack[this.depth] = npos;
                Branch<K, V> elem = this.nodeStack[this.depth][npos];
                if (elem instanceof SNode) {
                    this.current = (SNode)elem;
                } else if (elem instanceof INode) {
                    this.readin((INode)elem);
                }
            } else {
                --this.depth;
                this.advance();
            }
        } else {
            this.current = null;
        }
    }
}

