/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import tech.pantheon.triemap.Branch;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class CNode<K, V>
extends MainNode<K, V> {
    private static final Branch<?, ?>[] EMPTY_ARRAY = new Branch[0];
    final int bitmap;
    final Branch<K, V>[] array;
    private final Gen gen;
    private volatile int csize = -1;

    @SafeVarargs
    private CNode(CNode<K, V> prev, Gen gen, int bitmap, Branch<K, V> ... array) {
        super(prev);
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }

    @SafeVarargs
    private CNode(Gen gen, int bitmap, Branch<K, V> ... array) {
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }

    CNode(Gen gen) {
        this(gen, 0, EMPTY_ARRAY);
    }

    static <K, V> MainNode<K, V> dual(SNode<K, V> first, @NonNull K key, @NonNull V value, int hc, int initLev, Gen gen) {
        MainNode deepest;
        int len;
        int[] bmps;
        block3: {
            SNode<K, V> second = new SNode<K, V>(key, value, hc);
            int fhc = first.hc();
            bmps = new int[7];
            len = 0;
            for (int lev = initLev; lev < 32; lev += 5) {
                int xidx = fhc >>> lev & 0x1F;
                int yidx = hc >>> lev & 0x1F;
                int bmp = 1 << xidx | 1 << yidx;
                if (xidx == yidx) {
                    bmps[len++] = bmp;
                    continue;
                }
                deepest = xidx < yidx ? new CNode<K, V>(gen, bmp, first, second) : new CNode<K, V>(gen, bmp, second, first);
                break block3;
            }
            deepest = new LNode<K, V>(first, second);
        }
        while (len > 0) {
            deepest = new CNode<K, V>(gen, bmps[--len], new INode<K, V>(gen, deepest));
        }
        return deepest;
    }

    @Nullable Object computeIfAbsent(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull Function<? super K, ? extends V> fn, int lev, INode<K, V> parent) {
        int idx = hc >>> lev & 0x1F;
        int flag = 1 << idx;
        int mask = flag - 1;
        int pos = Integer.bitCount(this.bitmap & mask);
        if ((this.bitmap & flag) == 0) {
            V val = fn.apply(key);
            return val == null || this.insert(ct, parent, pos, flag, key, val, hc) ? val : Result.RESTART;
        }
        Branch<K, V> cnAtPos = this.array[pos];
        if (cnAtPos instanceof INode) {
            INode in = (INode)cnAtPos;
            return startGen != in.gen && !this.renew(ct, parent, startGen) ? Result.RESTART : in.computeIfAbsent(ct, startGen, hc, key, fn, lev + 5, parent);
        }
        if (cnAtPos instanceof SNode) {
            SNode sn = (SNode)cnAtPos;
            return this.computeIfAbsent(ct, parent, pos, sn, key, fn, hc, lev);
        }
        throw CNode.invalidElement(cnAtPos);
    }

    private @Nullable Object computeIfAbsent(MutableTrieMap<K, V> ct, INode<K, V> in, int pos, SNode<K, V> sn, @NonNull K key, @NonNull Function<? super K, ? extends V> fn, int hc, int lev) {
        if (sn.matches(hc, key)) {
            return sn.value();
        }
        V val = fn.apply(key);
        if (val == null) {
            return null;
        }
        CNode<K, V> rn = this.gen == in.gen ? this : this.renewed(ct, this.gen);
        return in.gcasWrite(ct, rn.updatedAt(pos, new INode<K, V>(in, sn, key, val, hc, lev), this.gen)) ? val : Result.RESTART;
    }

    @Nullable Object lookup(TrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, int lev, INode<K, V> parent) {
        int idx = hc >>> lev & 0x1F;
        int flag = 1 << idx;
        if ((this.bitmap & flag) == 0) {
            return null;
        }
        int pos = this.bitmap == -1 ? idx : Integer.bitCount(this.bitmap & flag - 1);
        Branch<K, V> sub = this.array[pos];
        if (sub instanceof INode) {
            INode in = (INode)sub;
            return ct.isReadOnly() || startGen == in.gen || this.renew(ct, parent, startGen) ? in.lookup(ct, startGen, hc, key, lev + 5, parent) : Result.RESTART;
        }
        if (sub instanceof SNode) {
            SNode sn = (SNode)sub;
            return sn.lookup(hc, key);
        }
        throw CNode.invalidElement(sub);
    }

    boolean insert(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull V val, int lev, INode<K, V> parent) {
        int idx = hc >>> lev & 0x1F;
        int flag = 1 << idx;
        int mask = flag - 1;
        int pos = Integer.bitCount(this.bitmap & mask);
        if ((this.bitmap & flag) == 0) {
            return this.insert(ct, parent, pos, flag, key, val, hc);
        }
        Branch<K, V> cnAtPos = this.array[pos];
        if (cnAtPos instanceof INode) {
            INode in = (INode)cnAtPos;
            return (startGen == in.gen || this.renew(ct, parent, startGen)) && in.insert(ct, startGen, hc, key, val, lev + 5, parent);
        }
        if (cnAtPos instanceof SNode) {
            SNode sn = (SNode)cnAtPos;
            return this.insert(ct, parent, pos, sn, key, val, hc, lev);
        }
        throw CNode.invalidElement(cnAtPos);
    }

    boolean insert(MutableTrieMap<K, V> ct, INode<K, V> in, int pos, SNode<K, V> sn, @NonNull K key, @NonNull V val, int hc, int lev) {
        CNode<K, V> next;
        if (!sn.matches(hc, key)) {
            CNode<K, V> rn = this.gen == in.gen ? this : this.renewed(ct, this.gen);
            next = rn.updatedAt(pos, new INode<K, V>(in, sn, key, val, hc, lev), this.gen);
        } else {
            next = this.updatedAt(pos, key, val, hc, this.gen);
        }
        return in.gcasWrite(ct, next);
    }

    boolean insert(MutableTrieMap<K, V> ct, INode<K, V> in, int pos, int flag, @NonNull K key, @NonNull V val, int hc) {
        Gen ngen = in.gen;
        CNode<K, V> rn = this.gen == ngen ? this : this.renewed(ct, ngen);
        return in.gcasWrite(ct, rn.toInsertedAt(this, ngen, pos, flag, key, val, hc));
    }

    @Nullable Object insertIf(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull V val, @Nullable Object cond, int lev, INode<K, V> parent) {
        int idx = hc >>> lev & 0x1F;
        int flag = 1 << idx;
        int bmp = this.bitmap;
        int mask = flag - 1;
        int pos = Integer.bitCount(bmp & mask);
        if ((bmp & flag) == 0) {
            return cond != null && cond != PresencePredicate.ABSENT || this.insert(ct, parent, pos, flag, key, val, hc) ? null : Result.RESTART;
        }
        Branch<K, V> cnAtPos = this.array[pos];
        if (cnAtPos instanceof INode) {
            INode in = (INode)cnAtPos;
            return startGen != in.gen && !this.renew(ct, parent, startGen) ? Result.RESTART : in.insertIf(ct, startGen, hc, key, val, cond, lev + 5, parent);
        }
        if (cnAtPos instanceof SNode) {
            SNode sn = (SNode)cnAtPos;
            return this.insertIf(ct, parent, pos, sn, key, val, hc, cond, lev);
        }
        throw CNode.invalidElement(cnAtPos);
    }

    private @Nullable Object insertIf(MutableTrieMap<K, V> ct, INode<K, V> in, int pos, SNode<K, V> sn, @NonNull K key, @NonNull V val, int hc, @Nullable Object cond, int lev) {
        if (!sn.matches(hc, key)) {
            if (cond == null || cond == PresencePredicate.ABSENT) {
                Gen ngen = in.gen;
                CNode<K, V> rn = this.gen == ngen ? this : this.renewed(ct, ngen);
                return in.gcasWrite(ct, rn.toUpdatedAt(this, pos, new INode<K, V>(in, sn, key, val, hc, lev), ngen)) ? null : Result.RESTART;
            }
            return null;
        }
        if (cond == PresencePredicate.ABSENT) {
            return sn.value();
        }
        if (cond == null || cond == PresencePredicate.PRESENT || cond.equals(sn.value())) {
            return in.gcasWrite(ct, this.updatedAt(pos, key, val, hc, this.gen)) ? sn.value() : Result.RESTART;
        }
        return null;
    }

    @Nullable Object remove(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @Nullable Object cond, int lev, INode<K, V> parent) {
        int idx = hc >>> lev & 0x1F;
        int flag = 1 << idx;
        if ((this.bitmap & flag) == 0) {
            return null;
        }
        int pos = Integer.bitCount(this.bitmap & flag - 1);
        Branch<K, V> sub = this.array[pos];
        if (sub instanceof INode) {
            INode in = (INode)sub;
            return startGen != in.gen && !this.renew(ct, parent, startGen) ? Result.RESTART : in.remove(ct, startGen, hc, key, cond, lev + 5, parent);
        }
        if (sub instanceof SNode) {
            SNode sn = (SNode)sub;
            if (!sn.matches(hc, key) || cond != null && !cond.equals(sn.value())) {
                return null;
            }
            return parent.gcasWrite(ct, this.toRemoved(ct, flag, pos, lev)) ? sn.value() : Result.RESTART;
        }
        throw CNode.invalidElement(sub);
    }

    private MainNode<K, V> toRemoved(MutableTrieMap<K, V> ct, int flag, int pos, int lev) {
        Branch<K, V>[] arr = this.array;
        int len = arr.length;
        Branch<K, V>[] narr = this.newArray(len - 1);
        System.arraycopy(arr, 0, narr, 0, pos);
        System.arraycopy(arr, pos + 1, narr, pos, len - pos - 1);
        return this.toUpdated(this.gen, lev, narr, this.bitmap ^ flag);
    }

    MainNode<K, V> toCompressed(TrieMap<K, V> ct, Gen ngen, int lev) {
        Branch<K, V>[] arr = this.array;
        int len = arr.length;
        Branch<K, V>[] narr = this.newArray(len);
        for (int i = 0; i < len; ++i) {
            Branch<K, V> branch;
            Branch<K, V> tmp = arr[i];
            if (tmp instanceof INode) {
                INode in = (INode)tmp;
                branch = in.resurrect(ct);
            } else {
                branch = tmp;
            }
            narr[i] = branch;
        }
        return this.toUpdated(ngen, lev, narr, this.bitmap);
    }

    MainNode<K, V> toContracted(Gen ngen, int pos, TNode<K, V> tn, int lev) {
        int len = this.array.length;
        Branch<K, V>[] narr = this.newArray(len);
        System.arraycopy(this.array, 0, narr, 0, len);
        narr[pos] = new SNode<K, V>(tn);
        return this.toUpdated(ngen, lev, narr, this.bitmap);
    }

    private MainNode<K, V> toUpdated(Gen ngen, int lev, Branch<K, V>[] arr, int bmp) {
        MainNode mainNode;
        Branch<K, V> branch;
        if (lev > 0 && arr.length == 1 && (branch = arr[0]) instanceof SNode) {
            SNode sn = (SNode)branch;
            mainNode = new TNode(this, sn);
        } else {
            mainNode = new CNode<K, V>(this, ngen, bmp, arr);
        }
        return mainNode;
    }

    private boolean renew(TrieMap<K, V> ct, INode<K, V> in, Gen ngen) {
        return in.gcasWrite(ct, this.renewed(ct, ngen));
    }

    @Override
    int trySize() {
        return this.csize;
    }

    @Override
    int size(ImmutableTrieMap<K, V> ct) {
        int sz = this.csize;
        return sz != -1 ? sz : (this.csize = this.computeSize(ct));
    }

    private int computeSize(ImmutableTrieMap<K, V> ct) {
        int len = this.array.length;
        return switch (len) {
            case 0 -> 0;
            case 1 -> this.array[0].elementSize(ct);
            default -> CNode.computeSize(ct, this.array, len);
        };
    }

    private static <K, V> int computeSize(ImmutableTrieMap<K, V> ct, Branch<K, V>[] array, int len) {
        int i;
        int offset = ThreadLocalRandom.current().nextInt(len);
        int sz = 0;
        for (i = offset; i < len; ++i) {
            sz += array[i].elementSize(ct);
        }
        for (i = 0; i < offset; ++i) {
            sz += array[i].elementSize(ct);
        }
        return sz;
    }

    private CNode<K, V> updatedAt(int pos, Branch<K, V> nn, Gen ngen) {
        return this.toUpdatedAt(this, pos, nn, ngen);
    }

    private CNode<K, V> updatedAt(int pos, @NonNull K key, @NonNull V val, int hc, Gen ngen) {
        return this.updatedAt(pos, new SNode<K, V>(key, val, hc), ngen);
    }

    private CNode<K, V> toInsertedAt(CNode<K, V> prev, Gen ngen, int pos, int flag, @NonNull K key, @NonNull V value, int hc) {
        int len = this.array.length;
        Branch<K, V>[] narr = this.newArray(len + 1);
        System.arraycopy(this.array, 0, narr, 0, pos);
        narr[pos] = new SNode<K, V>(key, value, hc);
        System.arraycopy(this.array, pos, narr, pos + 1, len - pos);
        return new CNode<K, V>(prev, ngen, this.bitmap | flag, narr);
    }

    private CNode<K, V> toUpdatedAt(CNode<K, V> prev, int pos, Branch<K, V> nn, Gen ngen) {
        int len = this.array.length;
        Branch<K, V>[] narr = this.newArray(len);
        System.arraycopy(this.array, 0, narr, 0, len);
        narr[pos] = nn;
        return new CNode<K, V>(prev, ngen, this.bitmap, narr);
    }

    private CNode<K, V> renewed(TrieMap<K, V> ct, Gen ngen) {
        Branch<K, V>[] arr = this.array;
        int len = arr.length;
        Branch<K, V>[] narr = this.newArray(len);
        for (int i = 0; i < len; ++i) {
            Branch<K, V> branch;
            Branch<K, V> tmp = arr[i];
            if (tmp instanceof INode) {
                INode in = (INode)tmp;
                branch = in.copyToGen(ct, ngen);
            } else {
                branch = tmp;
            }
            narr[i] = branch;
        }
        return new CNode<K, V>(this, ngen, this.bitmap, narr);
    }

    public String toString() {
        return "CNode";
    }

    private Branch<K, V>[] newArray(int size) {
        return new Branch[size];
    }

    static VerifyException invalidElement(Branch<?, ?> elem) {
        throw new VerifyException("A CNode can contain only INodes and SNodes, not " + String.valueOf(elem));
    }
}

