/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import tech.pantheon.triemap.Branch;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class INode<K, V>
implements Branch<K, V>,
MutableTrieMap.Root<K, V> {
    private static final VarHandle MAIN_VH;
    private static final VarHandle PREV_VH;
    final Gen gen;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile MainNode<K, V> main;

    INode(Gen gen, MainNode<K, V> mainNode) {
        MAIN_VH.set(this, mainNode);
        this.gen = gen;
    }

    INode(INode<K, V> prev, SNode<K, V> sn, @NonNull K key, @NonNull V val, int hc, int lev) {
        this(prev.gen, CNode.dual(sn, key, val, hc, lev + 5, prev.gen));
    }

    @NonNull MainNode<K, V> gcasReadNonNull(TrieMap<?, ?> ct) {
        return VerifyException.throwIfNull(this.gcasRead(ct));
    }

    MainNode<K, V> gcasRead(TrieMap<?, ?> ct) {
        return this.gcasComplete(ct, MAIN_VH.getVolatile(this));
    }

    boolean gcasWrite(TrieMap<?, ?> ct, MainNode<K, V> next) {
        if (MAIN_VH.compareAndSet(this, VerifyException.throwIfNull(PREV_VH.get(next)), next)) {
            this.gcasComplete(ct, next);
            return PREV_VH.getVolatile(next) == null;
        }
        return false;
    }

    private MainNode<K, V> gcasComplete(TrieMap<?, ?> ct, MainNode<K, V> firstMain) {
        MainNode currentMain = firstMain;
        while (true) {
            MainNode nextMain;
            block8: {
                Gcas prev;
                if ((prev = PREV_VH.getVolatile(currentMain)) == null) {
                    return currentMain;
                }
                while (true) {
                    Gcas witness;
                    if (prev instanceof FailedGcas) {
                        FailedGcas prevFailed = (FailedGcas)prev;
                        MainNode orig = prevFailed.orig;
                        witness = MAIN_VH.compareAndExchange(this, currentMain, orig);
                        if (witness == currentMain) {
                            return orig;
                        }
                        nextMain = witness;
                        break block8;
                    }
                    if (!(prev instanceof MainNode)) break;
                    MainNode prevMain = (MainNode)prev;
                    INode<?, ?> ctr = ct.readRoot(true);
                    if (ctr.gen != this.gen || ct.isReadOnly()) {
                        PREV_VH.compareAndSet(currentMain, prev, new FailedGcas(prevMain));
                        nextMain = MAIN_VH.getVolatile(this);
                        break block8;
                    }
                    witness = PREV_VH.compareAndExchange(currentMain, prev, null);
                    if (witness == prev || witness == null) {
                        return currentMain;
                    }
                    prev = witness;
                }
                throw new VerifyException("Unexpected gcas " + String.valueOf(prev));
            }
            if (nextMain == null) {
                return null;
            }
            currentMain = nextMain;
        }
    }

    INode<K, V> copyToGen(TrieMap<K, V> ct, Gen ngen) {
        return new INode<K, V>(ngen, this.gcasRead(ct));
    }

    @Override
    public int elementSize(ImmutableTrieMap<K, V> ct) {
        return this.gcasReadNonNull(ct).size(ct);
    }

    @Nullable Object lookup(TrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, int lev, INode<K, V> parent) {
        MainNode<K, V> m = this.gcasRead(ct);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            return cn.lookup(ct, startGen, hc, key, lev, this);
        }
        if (m instanceof TNode) {
            TNode tn = (TNode)m;
            if (ct.isReadOnly()) {
                return tn.hc == hc && key.equals(tn.key) ? tn.value : null;
            }
            this.clean(ct, parent, lev);
            return Result.RESTART;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            return ln.entries.lookup(key);
        }
        throw INode.invalidElement(m);
    }

    @Nullable Object computeIfAbsent(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull Function<? super K, ? extends V> fn, int lev, INode<K, V> parent) {
        MainNode<K, V> m = this.gcasRead(ct);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            return cn.computeIfAbsent(ct, startGen, hc, key, fn, lev, this);
        }
        if (m instanceof TNode) {
            this.clean(ct, parent, lev);
            return Result.RESTART;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            return ln.entries.computeIfAbsent((MutableTrieMap<? super K, ? extends V>)ct, this, ln, (K)key, fn);
        }
        throw INode.invalidElement(m);
    }

    boolean insert(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull V val, int lev, INode<K, V> parent) {
        MainNode<K, V> m = this.gcasRead(ct);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            return cn.insert(ct, startGen, hc, key, val, lev, this);
        }
        if (m instanceof TNode) {
            this.clean(ct, parent, lev);
            return false;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            return ln.entries.insert(ct, this, ln, key, val);
        }
        throw INode.invalidElement(m);
    }

    @Nullable Object insertIf(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @NonNull V val, Object cond, int lev, INode<K, V> parent) {
        MainNode<K, V> m = this.gcasRead(ct);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            return cn.insertIf(ct, startGen, hc, key, val, cond, lev, this);
        }
        if (m instanceof TNode) {
            this.clean(ct, parent, lev);
            return null;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            return ln.entries.insertIf(ct, this, ln, key, val, cond);
        }
        throw INode.invalidElement(m);
    }

    @Nullable Object remove(MutableTrieMap<K, V> ct, Gen startGen, int hc, @NonNull K key, @Nullable Object cond, int lev, INode<K, V> parent) {
        MainNode<K, V> m = this.gcasRead(ct);
        if (m instanceof CNode) {
            MainNode<K, V> mainNode;
            CNode cn = (CNode)m;
            Object res = cn.remove(ct, startGen, hc, key, cond, lev, this);
            if (res != null && res != Result.RESTART && parent != null && (mainNode = parent.gcasRead(ct)) instanceof TNode) {
                TNode tn = (TNode)mainNode;
                this.cleanParent(ct, startGen, hc, tn, parent, lev);
            }
            return res;
        }
        if (m instanceof TNode) {
            this.clean(ct, parent, lev);
            return Result.RESTART;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            return ln.entries.remove(ct, this, ln, key, cond, hc);
        }
        throw INode.invalidElement(m);
    }

    private void clean(TrieMap<K, V> ct, INode<K, V> parent, int lev) {
        MainNode<K, V> mainNode = parent.gcasRead(ct);
        if (mainNode instanceof CNode) {
            CNode cn = (CNode)mainNode;
            parent.gcasWrite(ct, cn.toCompressed(ct, this.gen, lev - 5));
        }
    }

    Branch<K, V> resurrect(TrieMap<K, V> ct) {
        Branch<K, V> branch;
        MainNode<K, V> mainNode = this.gcasReadNonNull(ct);
        if (mainNode instanceof TNode) {
            TNode tn = (TNode)mainNode;
            branch = new SNode(tn);
        } else {
            branch = this;
        }
        return branch;
    }

    private void cleanParent(MutableTrieMap<K, V> ct, Gen startGen, int hc, TNode<K, V> tn, INode<K, V> parent, int lev) {
        int pos;
        CNode cn;
        do {
            MainNode<K, V> mainNode;
            if (!((mainNode = parent.gcasRead(ct)) instanceof CNode)) {
                return;
            }
            cn = (CNode)mainNode;
            int idx = hc >>> lev - 5 & 0x1F;
            int bmp = cn.bitmap;
            int flag = 1 << idx;
            if ((bmp & flag) == 0) {
                return;
            }
            pos = Integer.bitCount(bmp & flag - 1);
            Branch sub = cn.array[pos];
            if (sub == this) continue;
            return;
        } while (!parent.gcasWrite(ct, cn.toContracted(this.gen, pos, tn, lev - 5)) && ct.readRoot().gen == startGen);
    }

    static VerifyException invalidElement(MainNode<?, ?> elem) {
        throw new VerifyException("An INode can host only a CNode, a TNode or an LNode, not " + String.valueOf(elem));
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MAIN_VH = lookup.findVarHandle(INode.class, "main", MainNode.class);
            PREV_VH = MethodHandles.lookup().findVarHandle(TryGcas.class, "prev", Gcas.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Gcas<K, V> {
    }

    @NonNullByDefault
    record FailedGcas<K, V>(MainNode<K, V> orig) implements Gcas<K, V>
    {
        FailedGcas {
            Objects.requireNonNull(orig);
        }

        @Override
        public String toString() {
            return "FailedNode(" + String.valueOf(this.orig) + ")";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class TryGcas<K, V>
    implements Gcas<K, V> {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
        private volatile Gcas<K, V> prev;

        private TryGcas(Gcas<K, V> prev) {
            PREV_VH.set(this, prev);
        }

        TryGcas() {
            this((Gcas)null);
        }

        TryGcas(CNode<K, V> prev) {
            this((Gcas)Objects.requireNonNull(prev));
        }

        TryGcas(LNode<K, V> prev) {
            this((Gcas)Objects.requireNonNull(prev));
        }
    }
}

