/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNodeEntries;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;

final class LNode<K, V>
extends MainNode<K, V> {
    final LNodeEntries<K, V> entries;
    final int size;

    LNode(LNode<K, V> prev, LNodeEntries<K, V> entries, int size) {
        super(prev);
        this.entries = entries;
        this.size = size;
    }

    LNode(SNode<K, V> first, SNode<K, V> second) {
        this.entries = LNodeEntries.of(first.key(), first.value(), second.key(), second.value());
        this.size = 2;
    }

    @Override
    int trySize() {
        return this.size;
    }

    @Override
    int size(ImmutableTrieMap<K, V> ct) {
        return this.size;
    }
}

