/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.LNodeEntry;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.VerifyException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class LNodeEntries<K, V>
extends LNodeEntry<K, V> {
    LNodeEntries(@NonNull K key, @NonNull V value) {
        super(key, value);
    }

    static <K, V> LNodeEntries<K, V> of(@NonNull K k1, @NonNull V v1, @NonNull K k2, @NonNull V v2) {
        return new Multiple<K, V>(k1, v1, new Single<K, V>(k2, v2));
    }

    abstract LNodeEntries<K, V> next();

    final @Nullable V lookup(@NonNull K key) {
        LNodeEntry<K, V> entry = this.findEntry(key);
        return entry != null ? (V)entry.value() : null;
    }

    @Nullable Object computeIfAbsent(MutableTrieMap<K, V> ct, INode<K, V> in, LNode<K, V> ln, @NonNull K key, @NonNull Function<? super K, ? extends V> fn) {
        LNodeEntry<K, V> entry = this.findEntry(key);
        if (entry != null) {
            return entry.value();
        }
        V val = fn.apply(key);
        return val == null || in.gcasWrite(ct, this.toInserted(ln, key, val)) ? val : Result.RESTART;
    }

    final boolean insert(MutableTrieMap<K, V> ct, INode<K, V> in, LNode<K, V> ln, @NonNull K key, @NonNull V val) {
        LNodeEntry<K, V> entry = this.findEntry(key);
        return in.gcasWrite(ct, entry == null ? this.toInserted(ln, key, val) : this.toReplaced(ln, entry, val));
    }

    @Nullable Object insertIf(MutableTrieMap<K, V> ct, INode<K, V> in, LNode<K, V> ln, @NonNull K key, @NonNull V val, Object cond) {
        LNodeEntry<K, V> entry = this.findEntry(key);
        if (entry == null) {
            return cond != null && cond != PresencePredicate.ABSENT || in.gcasWrite(ct, this.toInserted(ln, key, val)) ? null : Result.RESTART;
        }
        if (cond == PresencePredicate.ABSENT) {
            return entry.value();
        }
        if (cond == null || cond == PresencePredicate.PRESENT || cond.equals(entry.value())) {
            return in.gcasWrite(ct, this.toReplaced(ln, entry, val)) ? entry.value() : Result.RESTART;
        }
        return null;
    }

    @Nullable Object remove(MutableTrieMap<K, V> ct, INode<K, V> in, LNode<K, V> ln, @NonNull K key, @Nullable Object cond, int hc) {
        LNodeEntry<K, V> entry = this.findEntry(key);
        if (entry == null) {
            return null;
        }
        if (cond != null && !cond.equals(entry.value())) {
            return null;
        }
        LNodeEntries<K, V> map = VerifyException.throwIfNull(this.removeEntry(entry));
        int size = ln.size;
        MainNode next = size == 2 ? new TNode<K, V>(ln, map.key(), map.value(), hc) : new LNode<K, V>(ln, map, size - 1);
        return in.gcasWrite(ct, next) ? entry.value() : Result.RESTART;
    }

    private LNode<K, V> toInserted(LNode<K, V> ln, @NonNull K key, @NonNull V val) {
        return new LNode<K, V>(ln, this.insertEntry(key, val), ln.size + 1);
    }

    private LNode<K, V> toReplaced(LNode<K, V> ln, LNodeEntry<K, V> entry, @NonNull V val) {
        return new LNode<K, V>(ln, this.replace(entry, val), ln.size);
    }

    final LNodeEntries<K, V> replace(LNodeEntry<K, V> entry, @NonNull V value) {
        LNodeEntries<K, V> removed = this.removeEntry(entry);
        return removed == null ? new Single<K, V>(entry.key(), value) : new Multiple<K, V>(entry.key(), value, removed);
    }

    final @Nullable LNodeEntry<K, V> findEntry(@NonNull K key) {
        LNodeEntries<K, V> entry = this;
        do {
            if (!key.equals(entry.key())) continue;
            return entry;
        } while ((entry = entry.next()) != null);
        return null;
    }

    final LNodeEntries<K, V> insertEntry(@NonNull K key, @NonNull V value) {
        return new Multiple<K, V>(key, value, this);
    }

    final LNodeEntries<K, V> removeEntry(LNodeEntry<K, V> entry) {
        Multiple ret;
        if (entry == this) {
            return this.next();
        }
        Multiple last = ret = new Multiple(this);
        for (LNodeEntries<K, V> cur = this.next(); cur != null; cur = cur.next()) {
            if (entry == cur) {
                last.next = cur.next();
                return ret;
            }
            Multiple<K, V> tmp = new Multiple<K, V>(cur);
            last.next = tmp;
            last = tmp;
        }
        throw new VerifyException("Failed to find entry " + String.valueOf(entry));
    }

    private static final class Multiple<K, V>
    extends LNodeEntries<K, V> {
        LNodeEntries<K, V> next;

        Multiple(LNodeEntries<K, V> entry) {
            this(entry.key(), entry.value(), null);
        }

        Multiple(@NonNull K key, @NonNull V value, LNodeEntries<K, V> next) {
            super(key, value);
            this.next = next;
        }

        @Override
        LNodeEntries<K, V> next() {
            return this.next;
        }
    }

    static final class Single<K, V>
    extends LNodeEntries<K, V> {
        Single(@NonNull K key, @NonNull V value) {
            super(key, value);
        }

        @Override
        LNodeEntries<K, V> next() {
            return null;
        }
    }
}

