/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import tech.pantheon.triemap.AbstractEntry;
import tech.pantheon.triemap.AbstractIterator;
import tech.pantheon.triemap.DefaultEntry;
import tech.pantheon.triemap.MutableTrieMap;

final class MutableIterator<K, V>
extends AbstractIterator<K, V> {
    private final MutableTrieMap<K, V> mutable;
    private MutableEntry<K, V> lastReturned;

    MutableIterator(MutableTrieMap<K, V> map) {
        super(map.immutableSnapshot());
        this.mutable = map;
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        this.mutable.remove(this.lastReturned.key());
        this.lastReturned = null;
    }

    @Override
    MutableEntry<K, V> wrapEntry(DefaultEntry<K, V> entry) {
        MutableEntry<K, V> ret = new MutableEntry<K, V>(this.mutable, entry);
        this.lastReturned = ret;
        return ret;
    }

    static final class MutableEntry<K, V>
    extends AbstractEntry<K, V> {
        private final MutableTrieMap<K, V> map;
        private final DefaultEntry<K, V> delegate;
        private V newValue = null;

        private MutableEntry(MutableTrieMap<K, V> map, DefaultEntry<K, V> delegate) {
            this.map = map;
            this.delegate = delegate;
        }

        @Override
        public K key() {
            return this.delegate.key();
        }

        @Override
        public V value() {
            V val = this.newValue;
            return val != null ? val : this.delegate.value();
        }

        @Override
        public V setValue(V value) {
            V ret = this.value();
            this.map.put(this.key(), value);
            this.newValue = value;
            return ret;
        }
    }
}

