/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableEntrySet;
import tech.pantheon.triemap.MutableIterator;
import tech.pantheon.triemap.MutableKeySet;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

public final class MutableTrieMap<K, V>
extends TrieMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final VarHandle VH;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Handled through writeReplace()")
    private volatile transient Root<K, V> root;

    MutableTrieMap() {
        this(MutableTrieMap.newRootNode());
    }

    MutableTrieMap(INode<K, V> root) {
        this.root = Objects.requireNonNull(root);
    }

    @Override
    public void clear() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), MutableTrieMap.newRootNode())) {
        }
    }

    @Override
    public V put(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertIf(k, Objects.requireNonNull(value), null);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertIf(k, Objects.requireNonNull(value), (Object)PresencePredicate.ABSENT);
    }

    @Override
    public V remove(Object key) {
        return this.removeIf(Objects.requireNonNull(key), null);
    }

    @Override
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="API contract allows null value, but we do not")
    public boolean remove(Object key, Object value) {
        Object k = Objects.requireNonNull(key);
        return this.removeIf(k, Objects.requireNonNull(value)) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        K k = Objects.requireNonNull(key);
        return this.insertIf(k, Objects.requireNonNull(newValue), Objects.requireNonNull(oldValue)) != null;
    }

    @Override
    public V replace(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertIf(k, Objects.requireNonNull(value), (Object)PresencePredicate.PRESENT);
    }

    private @Nullable V insertIf(@NonNull K key, @NonNull V value, @Nullable Object cond) {
        INode<K, V> r;
        Object res;
        int hc = MutableTrieMap.computeHash(key);
        while ((res = (r = this.readRoot()).insertIf(this, r.gen, hc, key, value, cond, 0, null)) == Result.RESTART) {
        }
        return (V)res;
    }

    private @Nullable V removeIf(@NonNull K key, @Nullable Object cond) {
        INode r;
        Object res;
        int hc = MutableTrieMap.computeHash(key);
        while ((res = (r = this.readRoot()).remove(this, r.gen, hc, key, cond, 0, null)) == Result.RESTART) {
        }
        return (V)res;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        INode<? super K, ? extends V> r;
        Object res;
        K k = Objects.requireNonNull(key);
        int hc = MutableTrieMap.computeHash(key);
        Function<? super K, ? extends V> fn = Objects.requireNonNull(mappingFunction);
        while ((res = (r = this.readRoot()).computeIfAbsent(this, r.gen, hc, (K)k, fn, 0, null)) == Result.RESTART) {
        }
        return (V)res;
    }

    @Override
    public int size() {
        return this.immutableSnapshot().size();
    }

    private INode<K, V> snapshot() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), localRoot.copyToGen(this, new Gen()))) {
        }
        return localRoot;
    }

    @Override
    public ImmutableTrieMap<K, V> immutableSnapshot() {
        return new ImmutableTrieMap<K, V>(this.snapshot());
    }

    @Override
    public MutableTrieMap<K, V> mutableSnapshot() {
        return new MutableTrieMap<K, V>(this.snapshot().copyToGen(this, new Gen()));
    }

    MutableEntrySet<K, V> createEntrySet() {
        return new MutableEntrySet(this);
    }

    MutableKeySet<K> createKeySet() {
        return new MutableKeySet(this);
    }

    @Override
    MutableIterator<K, V> iterator() {
        return new MutableIterator(this);
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    INode<K, V> rdcssReadRoot(boolean abort) {
        Root<K, V> r = this.root;
        if (r instanceof INode) {
            INode in = (INode)r;
            return in;
        }
        if (r instanceof RdcssDescriptor) {
            RdcssDescriptor desc = (RdcssDescriptor)r;
            return this.rdcssComplete(desc, abort);
        }
        throw new VerifyException("Unhandled root " + String.valueOf(r));
    }

    private static <K, V> INode<K, V> newRootNode() {
        Gen gen = new Gen();
        return new INode(gen, new CNode(gen));
    }

    private Root<K, V> casRoot(Root<K, V> prev, Root<K, V> next) {
        return VH.compareAndExchange(this, prev, next);
    }

    private boolean rdcssRoot(INode<K, V> ov, MainNode<K, V> expectedmain, INode<K, V> nv) {
        RdcssDescriptor<K, V> desc = new RdcssDescriptor<K, V>(ov, expectedmain, nv);
        Root<K, V> witness = this.casRoot(ov, desc);
        if (witness == ov) {
            this.rdcssComplete(desc, false);
            return desc.readCommitted();
        }
        return false;
    }

    private INode<K, V> rdcssComplete(RdcssDescriptor<K, V> initial, boolean abort) {
        Root<K, V> next;
        RdcssDescriptor desc = initial;
        while (true) {
            RdcssDescriptor nextDesc;
            INode ov = desc.old;
            if (abort || ov.gcasRead(this) != desc.expectedmain) {
                next = this.casRoot(desc, ov);
                if (next == desc) {
                    return ov;
                }
            } else {
                INode nv = desc.nv;
                next = this.casRoot(desc, nv);
                if (next == desc) {
                    desc.setCommitted();
                    return nv;
                }
            }
            if (next instanceof INode) {
                INode inode = (INode)next;
                return inode;
            }
            if (!(next instanceof RdcssDescriptor)) break;
            desc = nextDesc = (RdcssDescriptor)next;
        }
        throw new VerifyException("Unhandled root " + String.valueOf(next));
    }

    static {
        try {
            VH = MethodHandles.lookup().findVarHandle(MutableTrieMap.class, "root", Root.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Root<K, V> {
    }

    private static final class RdcssDescriptor<K, V>
    implements Root<K, V> {
        final INode<K, V> old;
        final MainNode<K, V> expectedmain;
        final INode<K, V> nv;
        private volatile boolean committed;

        RdcssDescriptor(INode<K, V> old, MainNode<K, V> expectedmain, INode<K, V> nv) {
            this.old = old;
            this.expectedmain = expectedmain;
            this.nv = nv;
        }

        boolean readCommitted() {
            return this.committed;
        }

        void setCommitted() {
            this.committed = true;
        }
    }
}

