/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.Objects;
import tech.pantheon.triemap.Equivalence;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class SerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private transient TrieMap<Object, Object> map;
    private transient boolean readOnly;

    public SerializationProxy() {
    }

    SerializationProxy(ImmutableTrieMap<?, ?> map, boolean readOnly) {
        this.map = Objects.requireNonNull(map);
        this.readOnly = readOnly;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(Equivalence.Equals.INSTANCE);
        out.writeInt(this.map.size());
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
        out.writeBoolean(this.readOnly);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object eqObj = in.readObject();
        if (!(eqObj instanceof Equivalence)) {
            throw new InvalidObjectException("Expected Equivalence object instead of " + String.valueOf(eqObj));
        }
        MutableTrieMap tmp = new MutableTrieMap();
        int size = in.readInt();
        if (size < 0) {
            throw new StreamCorruptedException("Expected non-negative size instead of " + size);
        }
        for (int i = 0; i < size; ++i) {
            Object k = Objects.requireNonNull(in.readObject());
            Object v = Objects.requireNonNull(in.readObject());
            INode<Object, Object> r = tmp.readRoot();
            if (r.insert(tmp, r.gen, TrieMap.computeHash(k), k, v, 0, null)) continue;
            throw new VerifyException("Concurrent modification during serialization");
        }
        this.map = in.readBoolean() ? tmp.immutableSnapshot() : tmp;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.map == null) {
            throw new NotActiveException();
        }
        return this.map;
    }
}

