/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.AbstractEntry;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.EntryNode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.SNode;

final class TNode<K, V>
extends MainNode<K, V>
implements EntryNode<K, V> {
    final @NonNull K key;
    final @NonNull V value;
    final int hc;

    TNode(CNode<K, V> prev, @NonNull K key, @NonNull V value, int hc) {
        super(prev);
        this.key = key;
        this.value = value;
        this.hc = hc;
    }

    TNode(CNode<K, V> prev, SNode<K, V> sn) {
        this(prev, sn.key(), sn.value(), sn.hc());
    }

    TNode(LNode<K, V> prev, @NonNull K key, @NonNull V value, int hc) {
        super(prev);
        this.key = key;
        this.value = value;
        this.hc = hc;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    int trySize() {
        return 1;
    }

    @Override
    int size(ImmutableTrieMap<K, V> ct) {
        return 1;
    }

    @Override
    public int hashCode() {
        return AbstractEntry.hashCode(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        return AbstractEntry.equals(obj, this.key, this.value);
    }

    public String toString() {
        return AbstractEntry.toString(this.key, this.value);
    }
}

