/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8639.parser;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc8639.model.api.SubscribedNotificationsStatements;
import org.opendaylight.yangtools.rfc8639.model.api.SubscriptionStateNotificationEffectiveStatement;
import org.opendaylight.yangtools.rfc8639.model.api.SubscriptionStateNotificationStatement;
import org.opendaylight.yangtools.rfc8639.parser.RefSubscriptionStateNotificationStatement;
import org.opendaylight.yangtools.rfc8639.parser.SubscriptionStateNotificationEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8639.parser.SubscriptionStateNotificationStatementImpl;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractEmptyStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class SubscriptionStateNotificationStatementSupport
extends AbstractEmptyStatementSupport<SubscriptionStateNotificationStatement, SubscriptionStateNotificationEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)SubscribedNotificationsStatements.SUBSCRIPTION_STATE_NOTIFICATION).build();

    public SubscriptionStateNotificationStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)SubscribedNotificationsStatements.SUBSCRIPTION_STATE_NOTIFICATION, StatementSupport.StatementPolicy.exactReplica(), config, VALIDATOR);
    }

    public void onStatementAdded(StmtContext.Mutable<Empty, SubscriptionStateNotificationStatement, SubscriptionStateNotificationEffectiveStatement> stmt) {
        SourceException.throwIf((YangStmtMapping.NOTIFICATION != stmt.coerceParentContext().publicDefinition() ? 1 : 0) != 0, stmt, (String)"Only notifications may be marked with subscription-state-notification", (Object[])new Object[0]);
    }

    protected SubscriptionStateNotificationStatement createDeclared(BoundStmtCtx<Empty> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new SubscriptionStateNotificationStatementImpl(substatements);
    }

    protected SubscriptionStateNotificationStatement attachDeclarationReference(SubscriptionStateNotificationStatement stmt, DeclarationReference reference) {
        return new RefSubscriptionStateNotificationStatement(stmt, reference);
    }

    protected SubscriptionStateNotificationEffectiveStatement createEffective(EffectiveStmtCtx.Current<Empty, SubscriptionStateNotificationStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new SubscriptionStateNotificationEffectiveStatementImpl((SubscriptionStateNotificationStatement)stmt.declared(), substatements);
    }
}

