/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.status.AtomicCounter;

final class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutMs;
    private boolean reachedEndOfLife = false;
    private boolean closedByCommand = false;
    private final AtomicCounter clientTimeouts;
    private final AtomicCounter heartbeatTimestamp;

    AeronClient(long clientId, long clientLivenessTimeoutNs, AtomicCounter clientTimeouts, AtomicCounter heartbeatTimestamp) {
        this.clientId = clientId;
        this.clientLivenessTimeoutMs = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(clientLivenessTimeoutNs));
        this.clientTimeouts = clientTimeouts;
        this.heartbeatTimestamp = heartbeatTimestamp;
    }

    @Override
    public void close() {
        this.heartbeatTimestamp.close();
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (timeMs > this.heartbeatTimestamp.get() + this.clientLivenessTimeoutMs) {
            this.reachedEndOfLife = true;
            if (!this.closedByCommand) {
                this.clientTimeouts.incrementOrdered();
                conductor.clientTimeout(this.clientId);
            }
            conductor.unavailableCounter(this.clientId, this.heartbeatTimestamp.id());
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    long clientId() {
        return this.clientId;
    }

    boolean hasTimedOut() {
        return this.reachedEndOfLife;
    }

    void timeOfLastKeepaliveMs(long nowMs) {
        this.heartbeatTimestamp.setOrdered(nowMs);
    }

    void onClosedByCommand() {
        this.closedByCommand = true;
        this.heartbeatTimestamp.setOrdered(0L);
    }
}

