/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.api;

import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;

@NonNullByDefault
public interface DataTreeCandidate {
    public DataTreeCandidateNode getRootNode();

    public YangInstanceIdentifier getRootPath();

    public int hashCode();

    public boolean equals(@Nullable Object var1);

    public static sealed interface CandidateNode {
        public YangInstanceIdentifier.PathArgument name();

        @Deprecated(since="14.0.0", forRemoval=true)
        public DataTreeCandidateNode toLegacy();

        public static sealed interface WithChildren
        permits Appeared, Disappeared, Modified {
            public Collection<CandidateNode> children();

            public @Nullable CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument var1);

            default public Optional<CandidateNode> findModifiedChild(YangInstanceIdentifier.PathArgument childName) {
                return WithChildren.toOptional(this.modifiedChild(childName));
            }

            default public CandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument childName) {
                return (CandidateNode)Verify.verifyNotNull((Object)this.modifiedChild(childName), (String)"No modified child named %s", (Object[])new Object[]{childName});
            }

            private static <T> Optional<T> toOptional(@Nullable T obj) {
                return Optional.ofNullable(obj);
            }
        }

        public static sealed interface WithoutDataAfter
        extends CandidateNode,
        WithDataBefore
        permits Deleted, Disappeared {
            @Override
            default public YangInstanceIdentifier.PathArgument name() {
                return this.dataBefore().name();
            }
        }

        public static sealed interface WithDataAfter
        extends CandidateNode
        permits Appeared, Created, Modified, Replaced, Unmodified {
            public NormalizedNode dataAfter();

            @Override
            default public YangInstanceIdentifier.PathArgument name() {
                return this.dataAfter().name();
            }
        }

        public static sealed interface WithDataBefore
        permits Modified, Replaced, WithoutDataAfter {
            public NormalizedNode dataBefore();
        }

        public static non-sealed interface Unmodified
        extends WithDataAfter {
        }

        public static non-sealed interface Replaced
        extends WithDataBefore,
        WithDataAfter {
        }

        public static non-sealed interface Modified
        extends WithDataBefore,
        WithDataAfter,
        WithChildren {
        }

        public static non-sealed interface Disappeared
        extends WithoutDataAfter,
        WithChildren {
        }

        public static non-sealed interface Deleted
        extends WithoutDataAfter {
        }

        public static non-sealed interface Created
        extends WithDataAfter {
        }

        public static interface Compacted
        extends Unmodified {
        }

        public static non-sealed interface Appeared
        extends WithDataAfter,
        WithChildren {
        }
    }
}

