/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class SubstatementValidator {
    private final ImmutableMap<StatementDefinition, Cardinality> cardinalityMap;
    private final ImmutableMap<StatementDefinition, Cardinality> mandatoryStatements;
    private final StatementDefinition currentStatement;

    private SubstatementValidator(Builder builder) {
        this.cardinalityMap = builder.cardinalityMap.build();
        this.currentStatement = builder.currentStatement;
        this.mandatoryStatements = ImmutableMap.copyOf((Map)Maps.filterValues(this.cardinalityMap, Cardinality::isMandatory));
    }

    public static Builder builder(StatementDefinition currentStatement) {
        return new Builder(currentStatement);
    }

    public void validate(StmtContext<?, ?, ?> ctx) {
        Map<StatementDefinition, Integer> stmtCounts = ctx.allSubstatementsStream().collect(Collectors.groupingBy(CommonStmtCtx::publicDefinition, Collectors.summingInt(x -> 1)));
        HashMap<StatementDefinition, Cardinality> missingMandatory = new HashMap<StatementDefinition, Cardinality>((Map<StatementDefinition, Cardinality>)this.mandatoryStatements);
        for (Map.Entry<StatementDefinition, Integer> entry : stmtCounts.entrySet()) {
            StatementDefinition def = entry.getKey();
            Cardinality cardinality = (Cardinality)this.cardinalityMap.get((Object)def);
            if (cardinality == null) {
                if (ctx.namespaceItem(ParserNamespaces.EXTENSION, def.getStatementName()) != null) continue;
                RootStmtContext<?, ?, ?> root = ctx.getRoot();
                throw new InvalidSubstatementException(ctx, "%s is not valid for %s. Error in module %s (%s)", def, this.currentStatement, root.rawArgument(), ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, root));
            }
            int count = entry.getValue();
            if (cardinality.isMandatory()) {
                if (cardinality.min() > count) {
                    RootStmtContext<?, ?, ?> root = ctx.getRoot();
                    throw new InvalidSubstatementException(ctx, "Minimal count of %s for %s is %s, detected %s. Error in module %s (%s)", def, this.currentStatement, cardinality.min(), count, root.rawArgument(), ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, root));
                }
                missingMandatory.remove(def);
            }
            if (cardinality.max() >= count) continue;
            RootStmtContext<?, ?, ?> root = ctx.getRoot();
            throw new InvalidSubstatementException(ctx, "Maximal count of %s for %s is %s, detected %s. Error in module %s (%s)", def, this.currentStatement, cardinality.max(), count, root.rawArgument(), ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, root));
        }
        if (!missingMandatory.isEmpty()) {
            Map.Entry<StatementDefinition, Cardinality> e = missingMandatory.entrySet().iterator().next();
            RootStmtContext<?, ?, ?> root = ctx.getRoot();
            throw new MissingSubstatementException(ctx, "%s is missing %s. Minimal count is %s. Error in module %s (%s)", this.currentStatement, e.getKey(), e.getValue().min(), root.rawArgument(), ctx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, root));
        }
    }

    public static final class Builder {
        private static final Cardinality ONE_MAX = new Cardinality(1, Integer.MAX_VALUE);
        private static final Cardinality ONE_ONE = new Cardinality(1, 1);
        private static final Cardinality ZERO_MAX = new Cardinality(0, Integer.MAX_VALUE);
        private static final Cardinality ZERO_ONE = new Cardinality(0, 1);
        private final ImmutableMap.Builder<StatementDefinition, Cardinality> cardinalityMap = ImmutableMap.builder();
        private final StatementDefinition currentStatement;

        Builder(StatementDefinition currentStatement) {
            this.currentStatement = currentStatement;
        }

        private Builder add(StatementDefinition def, Cardinality card) {
            this.cardinalityMap.put((Object)def, (Object)card);
            return this;
        }

        public Builder add(StatementDefinition def, int min, int max) {
            if (max == Integer.MAX_VALUE) {
                return this.addAtLeast(def, min);
            }
            if (min == 0) {
                return this.addAtMost(def, max);
            }
            return this.add(def, new Cardinality(min, max));
        }

        public Builder addAtLeast(StatementDefinition def, int min) {
            return switch (min) {
                case 0 -> this.addAny(def);
                case 1 -> this.addMultiple(def);
                default -> this.add(def, new Cardinality(min, Integer.MAX_VALUE));
            };
        }

        public Builder addAtMost(StatementDefinition def, int max) {
            return max == Integer.MAX_VALUE ? this.addAny(def) : this.add(def, new Cardinality(0, max));
        }

        public Builder addAny(StatementDefinition def) {
            return this.add(def, ZERO_MAX);
        }

        public Builder addMandatory(StatementDefinition def) {
            return this.add(def, ONE_ONE);
        }

        public Builder addMultiple(StatementDefinition def) {
            return this.add(def, ONE_MAX);
        }

        public Builder addOptional(StatementDefinition def) {
            return this.add(def, ZERO_ONE);
        }

        public SubstatementValidator build() {
            return new SubstatementValidator(this);
        }
    }

    private record Cardinality(int min, int max) {
        Cardinality {
            Preconditions.checkArgument((min >= 0 ? 1 : 0) != 0, (String)"Min %s cannot be less than 0!", (int)min);
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (String)"Min %s can not be greater than max %s!", (int)min, (int)max);
        }

        boolean isMandatory() {
            return this.min > 0;
        }
    }
}

