/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.parser.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;

@Beta
public interface YangParser {
    public @NonNull Collection<Class<? extends SchemaSourceRepresentation>> supportedSourceRepresentations();

    public @NonNull Set<QName> supportedStatements();

    public @NonNull YangParser addSource(SchemaSourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public @NonNull YangParser addSources(SchemaSourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addSource(source);
        }
        return this;
    }

    default public @NonNull YangParser addSources(Collection<? extends SchemaSourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation schemaSourceRepresentation : sources) {
            this.addSource(schemaSourceRepresentation);
        }
        return this;
    }

    public YangParser addLibSource(SchemaSourceRepresentation var1) throws IOException, YangSyntaxErrorException;

    default public @NonNull YangParser addLibSources(SchemaSourceRepresentation ... sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    default public @NonNull YangParser addLibSources(Collection<SchemaSourceRepresentation> sources) throws IOException, YangSyntaxErrorException {
        for (SchemaSourceRepresentation source : sources) {
            this.addLibSource(source);
        }
        return this;
    }

    public @NonNull YangParser setSupportedFeatures(@NonNull Set<QName> var1);

    public @NonNull YangParser setModulesWithSupportedDeviations(@NonNull SetMultimap<QNameModule, QNameModule> var1);

    public @NonNull List<DeclaredStatement<?>> buildDeclaredModel() throws YangParserException;

    public @NonNull EffectiveModelContext buildEffectiveModel() throws YangParserException;

    default public @NonNull SchemaContext buildSchemaContext() throws YangParserException {
        return this.buildEffectiveModel();
    }
}

