/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;

public interface ChoiceSchemaNode
extends DataSchemaNode,
AugmentationTarget,
MandatoryAware {
    public Collection<? extends CaseSchemaNode> getCases();

    default public Optional<? extends CaseSchemaNode> findCase(QName qname) {
        Objects.requireNonNull(qname);
        return this.getCases().stream().filter(node -> qname.equals((Object)node.getQName())).findFirst();
    }

    @Beta
    default public List<? extends CaseSchemaNode> findCaseNodes(String localname) {
        return (List)this.getCases().stream().filter(node -> localname.equals(node.getQName().getLocalName())).collect(ImmutableList.toImmutableList());
    }

    @Beta
    default public Optional<DataSchemaNode> findDataSchemaChild(QName qname) {
        Objects.requireNonNull(qname);
        for (CaseSchemaNode caseSchemaNode : this.getCases()) {
            Optional<DataSchemaNode> child = caseSchemaNode.findDataChildByName(qname);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    public Optional<CaseSchemaNode> getDefaultCase();
}

