/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.HelperMethods;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public interface DataNodeContainer {
    public Collection<? extends TypeDefinition<?>> getTypeDefinitions();

    public Collection<? extends DataSchemaNode> getChildNodes();

    public Collection<? extends GroupingDefinition> getGroupings();

    @Deprecated
    default public @Nullable DataSchemaNode getDataChildByName(QName name) {
        return this.findDataChildByName(name).orElse(null);
    }

    public Optional<DataSchemaNode> findDataChildByName(QName var1);

    default public Optional<DataSchemaNode> findDataChildByName(QName first, QName ... others) {
        Optional<DataSchemaNode> optCurrent = this.findDataChildByName(first);
        for (QName qname : others) {
            DataSchemaNode current;
            if (!optCurrent.isPresent() || !((current = optCurrent.get()) instanceof DataNodeContainer)) {
                return Optional.empty();
            }
            optCurrent = ((DataNodeContainer)((Object)current)).findDataChildByName(qname);
        }
        return optCurrent;
    }

    public Collection<? extends UsesNode> getUses();

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName name) {
        Optional<DataSchemaNode> optDataChild = this.findDataChildByName(name);
        if (HelperMethods.isDataNode(optDataChild)) {
            return optDataChild;
        }
        for (DataSchemaNode dataSchemaNode : this.getChildNodes()) {
            if (!(dataSchemaNode instanceof ChoiceSchemaNode)) continue;
            for (CaseSchemaNode caseSchemaNode : ((ChoiceSchemaNode)dataSchemaNode).getCases()) {
                Optional<DataSchemaNode> caseChild = caseSchemaNode.findDataTreeChild(name);
                if (!caseChild.isPresent()) continue;
                return caseChild;
            }
        }
        return Optional.empty();
    }

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(QName ... path) {
        return this.findDataTreeChild(Arrays.asList(path));
    }

    @Beta
    default public Optional<DataSchemaNode> findDataTreeChild(Iterable<QName> path) {
        Iterator<QName> it = path.iterator();
        DataNodeContainer parent = this;
        Optional<DataSchemaNode> optChild;
        while (!(optChild = parent.findDataTreeChild(Objects.requireNonNull(it.next()))).isEmpty() && it.hasNext()) {
            DataSchemaNode child = optChild.get();
            Preconditions.checkArgument((boolean)(child instanceof DataNodeContainer), (String)"Path %s extends beyond terminal child %s", path, (Object)child);
            parent = (DataNodeContainer)((Object)child);
        }
        return optChild;
    }
}

