/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class PathFromRoot
extends AbstractList<QName>
implements Immutable {
    private static final QName[] EMPTY_QNAMES = new QName[0];
    private static final VarHandle QNAMES;
    private final SchemaPath path;
    private QName @Nullable [] qnames;

    PathFromRoot(SchemaPath path) {
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public Iterator<QName> iterator() {
        return Arrays.asList(this.qnames()).iterator();
    }

    @Override
    public Spliterator<QName> spliterator() {
        return Arrays.spliterator(this.qnames());
    }

    @Override
    public QName get(int index) {
        return this.qnames()[index];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.qnames().length;
    }

    private QName @NonNull [] qnames() {
        QName[] local = QNAMES.getAcquire(this);
        return local != null ? local : this.loadQNames();
    }

    private QName @NonNull [] loadQNames() {
        ArrayDeque<QName> tmp = new ArrayDeque<QName>();
        for (QName qname : this.path.getPathTowardsRoot()) {
            tmp.addFirst(qname);
        }
        QName[] result = tmp.toArray(EMPTY_QNAMES);
        QNAMES.setRelease(this, result);
        return result;
    }

    static {
        try {
            QNAMES = MethodHandles.lookup().findVarHandle(PathFromRoot.class, "qnames", QName[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

