/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public abstract class SchemaNodeIdentifier
implements Immutable {
    private static final AtomicReferenceFieldUpdater<SchemaNodeIdentifier, SchemaPath> SCHEMAPATH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SchemaNodeIdentifier.class, SchemaPath.class, "schemaPath");
    private final @NonNull Object qnames;
    private volatile SchemaPath schemaPath;
    private volatile int hash;

    SchemaNodeIdentifier(QName qname) {
        this.qnames = Objects.requireNonNull(qname);
    }

    SchemaNodeIdentifier(Collection<QName> qnames) {
        ImmutableList tmp = ImmutableList.copyOf(qnames);
        Preconditions.checkArgument((!tmp.isEmpty() ? 1 : 0) != 0);
        this.qnames = tmp.size() == 1 ? tmp.get(0) : tmp;
    }

    public @NonNull List<QName> getNodeIdentifiers() {
        return this.qnames instanceof QName ? ImmutableList.of((Object)((QName)this.qnames)) : (ImmutableList)this.qnames;
    }

    public final @NonNull SchemaPath asSchemaPath() {
        SchemaPath ret = this.schemaPath;
        return ret != null ? ret : this.loadSchemaPath();
    }

    private SchemaPath loadSchemaPath() {
        SchemaPath newPath = this.implicitSchemaPathParent().createChild(this.getNodeIdentifiers());
        return SCHEMAPATH_UPDATER.compareAndSet(this, null, newPath) ? newPath : this.schemaPath;
    }

    abstract SchemaPath implicitSchemaPathParent();

    public final int hashCode() {
        int local = this.hash;
        return local != 0 ? local : (this.hash = this.qnames.hashCode());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.qnames.equals(((SchemaNodeIdentifier)obj).qnames);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qnames", this.toStringQNames()).toString();
    }

    private List<?> toStringQNames() {
        List<QName> ids = this.getNodeIdentifiers();
        return ids.size() < 2 ? ids : SchemaNodeIdentifier.simplifyQNames(ids);
    }

    private static List<?> simplifyQNames(List<QName> qnames) {
        ArrayList<QName> ret = new ArrayList<QName>(qnames.size());
        QNameModule prev = null;
        for (QName qname : qnames) {
            QNameModule module = qname.getModule();
            ret.add((QName)(module.equals(prev) ? qname.getLocalName() : qname));
            prev = module;
        }
        return ret;
    }

    public static final class Descendant
    extends SchemaNodeIdentifier {
        Descendant(QName qname) {
            super(qname);
        }

        Descendant(Collection<QName> qnames) {
            super(qnames);
        }

        public static @NonNull Descendant of(QName nodeIdentifier) {
            return new Descendant(nodeIdentifier);
        }

        public static @NonNull Descendant of(QName ... nodeIdentifiers) {
            return new Descendant(Arrays.asList(nodeIdentifiers));
        }

        public static @NonNull Descendant of(Collection<QName> nodeIdentifiers) {
            return new Descendant(nodeIdentifiers);
        }

        @Override
        SchemaPath implicitSchemaPathParent() {
            return SchemaPath.SAME;
        }
    }

    public static final class Absolute
    extends SchemaNodeIdentifier {
        Absolute(QName qname) {
            super(qname);
        }

        Absolute(Collection<QName> qnames) {
            super(qnames);
        }

        public static @NonNull Absolute of(QName nodeIdentifier) {
            return new Absolute(nodeIdentifier);
        }

        public static @NonNull Absolute of(QName ... nodeIdentifiers) {
            return new Absolute(Arrays.asList(nodeIdentifiers));
        }

        public static @NonNull Absolute of(Collection<QName> nodeIdentifiers) {
            return new Absolute((Collection<QName>)ImmutableList.copyOf(nodeIdentifiers));
        }

        @Override
        SchemaPath implicitSchemaPathParent() {
            return SchemaPath.ROOT;
        }
    }
}

