/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import java.util.List;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.command.completers.ProfileCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(name="change-parents", scope="profile", description="Replace the profile's parents with the specified list of parents")
@Service
public class ProfileChangeParents
implements Action {
    @Argument(index=0, required=true, name="profile", description="Name of the profile.")
    @Completion(value=ProfileCompleter.class)
    private String profileId;
    @Argument(index=1, name="parents", description="The list of new parent profiles.", required=true, multiValued=true)
    @Completion(value=ProfileCompleter.class)
    private List<String> parentIds;
    @Reference
    private ProfileService profileService;

    public Object execute() throws Exception {
        Profile profile = this.profileService.getRequiredProfile(this.profileId);
        Profile newProfile = ProfileBuilder.Factory.createFrom(profile).addParents(this.parentIds).getProfile();
        this.profileService.updateProfile(newProfile);
        return null;
    }
}

