/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import akka.actor.Props;
import akka.actor.UntypedAbstractActor;
import akka.japi.Effect;
import akka.remote.ThisActorSystemQuarantinedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarantinedMonitorActor
extends UntypedAbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(QuarantinedMonitorActor.class);
    public static final String ADDRESS = "quarantined-monitor";
    private final Effect callback;
    private boolean quarantined;

    protected QuarantinedMonitorActor(Effect callback) {
        this.callback = callback;
        LOG.debug("Created QuarantinedMonitorActor");
        this.getContext().system().eventStream().subscribe(this.getSelf(), ThisActorSystemQuarantinedEvent.class);
    }

    public void postStop() {
        LOG.debug("Stopping QuarantinedMonitorActor");
    }

    public void onReceive(Object message) throws Exception {
        String messageType = message.getClass().getSimpleName();
        LOG.trace("onReceive {} {}", (Object)messageType, message);
        if (this.quarantined) {
            return;
        }
        if (message instanceof ThisActorSystemQuarantinedEvent) {
            ThisActorSystemQuarantinedEvent event = (ThisActorSystemQuarantinedEvent)message;
            LOG.warn("Got quarantined by {}", (Object)event.remoteAddress());
            this.quarantined = true;
            this.callback.apply();
        }
    }

    public static Props props(Effect callback) {
        return Props.create(QuarantinedMonitorActor.class, (Object[])new Object[]{callback});
    }
}

