/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.messaging.AssemblerClosedException;
import org.opendaylight.controller.cluster.messaging.AssemblerSealedException;
import org.opendaylight.controller.cluster.messaging.MessageSliceException;
import org.opendaylight.yangtools.concepts.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembledMessageState
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AssembledMessageState.class);
    private final int totalSlices;
    private final BufferedOutputStream bufferedStream;
    private final FileBackedOutputStream fileBackedStream;
    private final Identifier identifier;
    private final String logContext;
    private int lastSliceIndexReceived = 0;
    private int lastSliceHashCodeReceived = -1;
    private boolean sealed = false;
    private boolean closed = false;
    private long assembledSize;

    public AssembledMessageState(Identifier identifier, int totalSlices, FileBackedOutputStreamFactory fileBackedStreamFactory, String logContext) {
        this.identifier = identifier;
        this.totalSlices = totalSlices;
        this.logContext = logContext;
        this.fileBackedStream = fileBackedStreamFactory.newInstance();
        this.bufferedStream = new BufferedOutputStream(this.fileBackedStream);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean addSlice(int sliceIndex, byte[] data, int lastSliceHashCode) throws MessageSliceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: addSlice: identifier: {}, sliceIndex: {}, lastSliceIndex: {}, assembledSize: {}, sliceHashCode: {}, lastSliceHashCode: {}", new Object[]{this.logContext, this.identifier, sliceIndex, this.lastSliceIndexReceived, this.assembledSize, lastSliceHashCode, this.lastSliceHashCodeReceived});
        }
        try {
            this.validateSlice(sliceIndex, lastSliceHashCode);
            this.assembledSize += (long)data.length;
            this.lastSliceIndexReceived = sliceIndex;
            this.lastSliceHashCodeReceived = Arrays.hashCode(data);
            this.bufferedStream.write(data);
            boolean bl = this.sealed = sliceIndex == this.totalSlices;
            if (this.sealed) {
                this.bufferedStream.close();
            }
        }
        catch (IOException e) {
            this.close();
            throw new MessageSliceException(String.format("Error writing data for slice %d of message %s", sliceIndex, this.identifier), e);
        }
        return this.sealed;
    }

    public ByteSource getAssembledBytes() throws IOException {
        Preconditions.checkState((boolean)this.sealed, (Object)"Last slice not received yet");
        return this.fileBackedStream.asByteSource();
    }

    private void validateSlice(int sliceIndex, int lastSliceHashCode) throws MessageSliceException {
        if (this.closed) {
            throw new AssemblerClosedException(this.identifier);
        }
        if (this.sealed) {
            throw new AssemblerSealedException(String.format("Received slice index for message %s but all %d expected slices have already already received.", this.identifier, this.totalSlices));
        }
        if (this.lastSliceIndexReceived + 1 != sliceIndex) {
            this.close();
            throw new MessageSliceException(String.format("Expected sliceIndex %d but got %d for message %s", this.lastSliceIndexReceived + 1, sliceIndex, this.identifier), true);
        }
        if (lastSliceHashCode != this.lastSliceHashCodeReceived) {
            this.close();
            throw new MessageSliceException(String.format("The hash code of the recorded last slice (%d) does not match the senders last hash code (%d) for message %s", this.lastSliceHashCodeReceived, lastSliceHashCode, this.identifier), true);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.sealed) {
            try {
                this.bufferedStream.close();
            }
            catch (IOException e) {
                LOG.debug("{}: Error closing output stream", (Object)this.logContext, (Object)e);
            }
        }
        this.fileBackedStream.cleanup();
    }
}

