/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class MessageSliceIdentifier
implements Identifier {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong ID_COUNTER = new AtomicLong(1L);
    private final Identifier clientIdentifier;
    private final long slicerId;
    private final long messageId;

    MessageSliceIdentifier(Identifier clientIdentifier, long slicerId) {
        this(clientIdentifier, slicerId, ID_COUNTER.getAndIncrement());
    }

    private MessageSliceIdentifier(Identifier clientIdentifier, long slicerId, long messageId) {
        this.clientIdentifier = Objects.requireNonNull(clientIdentifier);
        this.messageId = messageId;
        this.slicerId = slicerId;
    }

    Identifier getClientIdentifier() {
        return this.clientIdentifier;
    }

    long getSlicerId() {
        return this.slicerId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clientIdentifier.hashCode();
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        result = 31 * result + (int)(this.slicerId ^ this.slicerId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessageSliceIdentifier)) {
            return false;
        }
        MessageSliceIdentifier other = (MessageSliceIdentifier)obj;
        return other.clientIdentifier.equals((Object)this.clientIdentifier) && other.slicerId == this.slicerId && other.messageId == this.messageId;
    }

    public String toString() {
        return "MessageSliceIdentifier [clientIdentifier=" + this.clientIdentifier + ", slicerId=" + this.slicerId + ", messageId=" + this.messageId + "]";
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MessageSliceIdentifier messageSliceId;

        public Proxy() {
        }

        Proxy(MessageSliceIdentifier messageSliceId) {
            this.messageSliceId = messageSliceId;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.messageSliceId.clientIdentifier);
            WritableObjects.writeLongs((DataOutput)out, (long)this.messageSliceId.slicerId, (long)this.messageSliceId.messageId);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Identifier clientIdentifier = (Identifier)in.readObject();
            byte header = WritableObjects.readLongHeader((DataInput)in);
            long slicerId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
            long messageId = WritableObjects.readSecondLong((DataInput)in, (byte)header);
            this.messageSliceId = new MessageSliceIdentifier(clientIdentifier, slicerId, messageId);
        }

        private Object readResolve() {
            return this.messageSliceId;
        }
    }
}

