/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;

final class ChunkedInputStream
extends InputStream {
    private final Iterator<byte[]> remainingChunks;
    private byte[] currentChunk;
    private int currentLimit;
    private int currentOffset;
    private int available;

    ChunkedInputStream(int size, Iterator<byte[]> iterator) {
        this.remainingChunks = Objects.requireNonNull(iterator);
        this.currentChunk = this.remainingChunks.next();
        this.currentLimit = this.currentChunk.length;
        this.available = size;
    }

    @Override
    public int available() {
        return this.available;
    }

    @Override
    public int read() {
        if (this.currentChunk == null) {
            return -1;
        }
        int ret = this.currentChunk[this.currentOffset] & 0xFF;
        this.consumeBytes(1);
        return ret;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.currentChunk == null) {
            return -1;
        }
        int result = Math.min(this.available, len);
        int toOffset = off;
        for (int toCopy = result; toCopy != 0; toCopy -= count) {
            count = this.currentBytes(toCopy);
            System.arraycopy(this.currentChunk, this.currentOffset, b, toOffset, count);
            this.consumeBytes(count);
            toOffset += count;
        }
        return result;
    }

    @Override
    public long skip(long n) {
        int result;
        int count;
        for (int toSkip = result = (int)Math.min((long)this.available, n); toSkip != 0; toSkip -= count) {
            count = this.currentBytes(toSkip);
            this.consumeBytes(count);
        }
        return result;
    }

    private int currentBytes(int desired) {
        return Math.min(desired, this.currentLimit - this.currentOffset);
    }

    private void consumeBytes(int count) {
        this.currentOffset += count;
        this.available -= count;
        if (this.currentOffset == this.currentLimit) {
            if (this.remainingChunks.hasNext()) {
                this.currentChunk = this.remainingChunks.next();
                this.currentLimit = this.currentChunk.length;
            } else {
                this.currentChunk = null;
                this.currentLimit = 0;
            }
            this.currentOffset = 0;
        }
    }
}

