/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.inventory.rev131030;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.inventory.rev131030.InventoryNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InventoryNodeBuilder
implements Builder<InventoryNode> {
    private NodeRef _inventoryNodeRef;

    public InventoryNodeBuilder() {
    }

    public InventoryNodeBuilder(InventoryNode base) {
        this._inventoryNodeRef = base.getInventoryNodeRef();
    }

    public NodeRef getInventoryNodeRef() {
        return this._inventoryNodeRef;
    }

    public InventoryNodeBuilder setInventoryNodeRef(NodeRef value) {
        this._inventoryNodeRef = value;
        return this;
    }

    public InventoryNode build() {
        return new InventoryNodeImpl(this);
    }

    private static final class InventoryNodeImpl
    implements InventoryNode {
        private final NodeRef _inventoryNodeRef;
        private int hash = 0;
        private volatile boolean hashValid = false;

        InventoryNodeImpl(InventoryNodeBuilder base) {
            this._inventoryNodeRef = base.getInventoryNodeRef();
        }

        @Override
        public NodeRef getInventoryNodeRef() {
            return this._inventoryNodeRef;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            this.hash = result = 31 * result + Objects.hashCode(this._inventoryNodeRef);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InventoryNode.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            InventoryNode other = (InventoryNode)obj;
            return Objects.equals(this._inventoryNodeRef, other.getInventoryNodeRef());
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"InventoryNode");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inventoryNodeRef", (Object)this._inventoryNodeRef);
            return helper.toString();
        }
    }
}

