/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.codec.BitsCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

@Beta
public final class BitsStringCodec
extends TypeDefinitionAwareCodec<Set<String>, BitsTypeDefinition>
implements BitsCodec<String> {
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();
    private static final Splitter SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private final ImmutableSet<String> validBits;

    private BitsStringCodec(@NonNull BitsTypeDefinition typeDef) {
        super(typeDef, Set.class);
        this.validBits = ImmutableSet.copyOf((Collection)Collections2.transform((Collection)typeDef.getBits(), BitsTypeDefinition.Bit::getName));
    }

    public static BitsStringCodec from(BitsTypeDefinition type) {
        return new BitsStringCodec(Objects.requireNonNull(type));
    }

    protected @NonNull Set<String> deserializeImpl(@NonNull String product) {
        ImmutableSet strings = ImmutableSet.copyOf((Iterable)SPLITTER.split((CharSequence)product));
        ArrayList<String> sorted = new ArrayList<String>(strings.size());
        for (String bit : this.validBits) {
            if (!strings.contains(bit)) continue;
            sorted.add(bit);
        }
        if (sorted.size() != strings.size()) {
            for (String bit : strings) {
                Preconditions.checkArgument((boolean)this.validBits.contains((Object)bit), (String)"Invalid value '%s' for bits type. Allowed values are: %s", (Object)bit, this.validBits);
            }
        }
        return sorted.size() == this.validBits.size() ? this.validBits : ImmutableSet.copyOf(sorted);
    }

    protected String serializeImpl(Set<String> input) {
        return JOINER.join(input);
    }
}

