/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefDataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNameWithPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeafRefValidation {
    private static final Logger LOG = LoggerFactory.getLogger(LeafRefValidation.class);
    private static final String FAILED = " -> FAILED";
    private static final String SUCCESS = " -> OK";
    private final Set<LeafRefContext> validatedLeafRefCtx = new HashSet<LeafRefContext>();
    private final List<String> errorsMessages = new ArrayList<String>();
    private final NormalizedNode<?, ?> root;

    private LeafRefValidation(NormalizedNode<?, ?> root) {
        this.root = root;
    }

    public static void validate(DataTreeCandidate tree, LeafRefContext rootLeafRefCtx) throws LeafRefDataValidationFailedException {
        Optional root = tree.getRootNode().getDataAfter();
        if (root.isPresent()) {
            new LeafRefValidation((NormalizedNode)root.get()).validateChildren(rootLeafRefCtx, tree.getRootNode().getChildNodes());
        }
    }

    private void validateChildren(LeafRefContext rootLeafRefCtx, Collection<DataTreeCandidateNode> children) throws LeafRefDataValidationFailedException {
        for (DataTreeCandidateNode dataTreeCandidateNode : children) {
            if (dataTreeCandidateNode.getModificationType() == ModificationType.UNMODIFIED) continue;
            YangInstanceIdentifier.PathArgument identifier = dataTreeCandidateNode.getIdentifier();
            QName childQName = identifier.getNodeType();
            LeafRefContext referencedByCtx = rootLeafRefCtx.getReferencedChildByName(childQName);
            LeafRefContext referencingCtx = rootLeafRefCtx.getReferencingChildByName(childQName);
            if (referencedByCtx == null && referencingCtx == null) continue;
            this.validateNode(dataTreeCandidateNode, referencedByCtx, referencingCtx, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{identifier}));
        }
        if (!this.errorsMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            int errCount = 0;
            for (String errorMessage : this.errorsMessages) {
                message.append(errorMessage);
                ++errCount;
            }
            throw new LeafRefDataValidationFailedException(message.toString(), errCount);
        }
    }

    private void validateNode(DataTreeCandidateNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, YangInstanceIdentifier current) {
        if (node.getModificationType() == ModificationType.WRITE && node.getDataAfter().isPresent()) {
            this.validateNodeData((NormalizedNode)node.getDataAfter().get(), referencedByCtx, referencingCtx, node.getModificationType(), current);
            return;
        }
        if (node.getModificationType() == ModificationType.DELETE && referencedByCtx != null) {
            this.validateNodeData((NormalizedNode)node.getDataBefore().get(), referencedByCtx, null, node.getModificationType(), current);
            return;
        }
        for (DataTreeCandidateNode childNode : node.getChildNodes()) {
            if (childNode.getModificationType() == ModificationType.UNMODIFIED) continue;
            LeafRefContext childReferencedByCtx = LeafRefValidation.getReferencedByCtxChild(referencedByCtx, childNode);
            LeafRefContext childReferencingCtx = LeafRefValidation.getReferencingCtxChild(referencingCtx, childNode);
            if (childReferencedByCtx == null && childReferencingCtx == null) continue;
            this.validateNode(childNode, childReferencedByCtx, childReferencingCtx, current.node(childNode.getIdentifier()));
        }
    }

    private static LeafRefContext getReferencingCtxChild(LeafRefContext referencingCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencingCtx == null) {
            return null;
        }
        QName childQName = childNode.getIdentifier().getNodeType();
        LeafRefContext childReferencingCtx = referencingCtx.getReferencingChildByName(childQName);
        if (childReferencingCtx == null && ((data = (NormalizedNode)childNode.getDataAfter().get()) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencingCtx = referencingCtx;
        }
        return childReferencingCtx;
    }

    private static LeafRefContext getReferencedByCtxChild(LeafRefContext referencedByCtx, DataTreeCandidateNode childNode) {
        NormalizedNode data;
        if (referencedByCtx == null) {
            return null;
        }
        QName childQName = childNode.getIdentifier().getNodeType();
        LeafRefContext childReferencedByCtx = referencedByCtx.getReferencedChildByName(childQName);
        if (childReferencedByCtx == null && ((data = (NormalizedNode)childNode.getDataAfter().get()) instanceof MapEntryNode || data instanceof UnkeyedListEntryNode)) {
            childReferencedByCtx = referencedByCtx;
        }
        return childReferencedByCtx;
    }

    private void validateNodeData(NormalizedNode<?, ?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        if (node instanceof LeafNode) {
            this.validateLeafNodeData((LeafNode)node, referencedByCtx, referencingCtx, modificationType, current);
        } else if (node instanceof LeafSetNode) {
            this.validateLeafSetNodeData((LeafSetNode)node, referencedByCtx, referencingCtx, modificationType, current);
        } else if (node instanceof ChoiceNode) {
            this.validateChoiceNodeData((ChoiceNode)node, referencedByCtx, referencingCtx, modificationType, current);
        } else if (node instanceof DataContainerNode) {
            this.validateDataContainerNodeData((DataContainerNode)node, referencedByCtx, referencingCtx, modificationType, current);
        } else if (node instanceof MapNode) {
            this.validateMapNodeData((MapNode)node, referencedByCtx, referencingCtx, modificationType, current);
        }
    }

    private void validateLeafNodeData(LeafNode<?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        if (referencedByCtx != null && referencedByCtx.isReferenced()) {
            this.validateLeafRefTargetNodeData((NormalizedNode<?, ?>)node, referencedByCtx, modificationType);
        }
        if (referencingCtx != null && referencingCtx.isReferencing()) {
            this.validateLeafRefNodeData((NormalizedNode<?, ?>)node, referencingCtx, modificationType, current);
        }
    }

    private void validateLeafSetNodeData(LeafSetNode<?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        if (referencedByCtx != null || referencingCtx != null) {
            for (NormalizedNode leafSetEntry : node.getValue()) {
                if (referencedByCtx != null && referencedByCtx.isReferenced()) {
                    this.validateLeafRefTargetNodeData(leafSetEntry, referencedByCtx, modificationType);
                }
                if (referencingCtx == null || !referencingCtx.isReferencing()) continue;
                this.validateLeafRefNodeData(leafSetEntry, referencingCtx, modificationType, current);
            }
        }
    }

    private void validateChoiceNodeData(ChoiceNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (DataContainerChild child : node.getValue()) {
            LeafRefContext childReferencingCtx;
            QName qname = child.getNodeType();
            LeafRefContext childReferencedByCtx = referencedByCtx == null ? null : LeafRefValidation.findReferencedByCtxUnderChoice(referencedByCtx, qname);
            LeafRefContext leafRefContext = childReferencingCtx = referencingCtx == null ? null : LeafRefValidation.findReferencingCtxUnderChoice(referencingCtx, qname);
            if (childReferencedByCtx == null && childReferencingCtx == null) continue;
            this.validateNodeData((NormalizedNode<?, ?>)child, childReferencedByCtx, childReferencingCtx, modificationType, current.node(child.getIdentifier()));
        }
    }

    private void validateDataContainerNodeData(DataContainerNode<?> node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (DataContainerChild child : node.getValue()) {
            if (child instanceof AugmentationNode) {
                this.validateNodeData((NormalizedNode<?, ?>)child, referencedByCtx, referencingCtx, modificationType, current.node(child.getIdentifier()));
                return;
            }
            this.validateChildNodeData(child, referencedByCtx, referencingCtx, modificationType, current);
        }
    }

    private void validateMapNodeData(MapNode node, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        for (MapEntryNode mapEntry : node.getValue()) {
            YangInstanceIdentifier mapEntryIdentifier = current.node((YangInstanceIdentifier.PathArgument)mapEntry.getIdentifier());
            for (DataContainerChild child : mapEntry.getValue()) {
                if (child instanceof AugmentationNode) {
                    this.validateNodeData((NormalizedNode<?, ?>)child, referencedByCtx, referencingCtx, modificationType, current.node(child.getIdentifier()));
                    return;
                }
                this.validateChildNodeData(child, referencedByCtx, referencingCtx, modificationType, mapEntryIdentifier);
            }
        }
    }

    private void validateChildNodeData(DataContainerChild<?, ?> child, LeafRefContext referencedByCtx, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        LeafRefContext childReferencingCtx;
        QName qname = child.getNodeType();
        LeafRefContext childReferencedByCtx = referencedByCtx == null ? null : referencedByCtx.getReferencedChildByName(qname);
        LeafRefContext leafRefContext = childReferencingCtx = referencingCtx == null ? null : referencingCtx.getReferencingChildByName(qname);
        if (childReferencedByCtx != null || childReferencingCtx != null) {
            this.validateNodeData((NormalizedNode<?, ?>)child, childReferencedByCtx, childReferencingCtx, modificationType, current.node(child.getIdentifier()));
        }
    }

    private static LeafRefContext findReferencingCtxUnderChoice(LeafRefContext referencingCtx, QName qname) {
        for (LeafRefContext child : referencingCtx.getReferencingChilds().values()) {
            LeafRefContext referencingChildByName = child.getReferencingChildByName(qname);
            if (referencingChildByName == null) continue;
            return referencingChildByName;
        }
        return null;
    }

    private static LeafRefContext findReferencedByCtxUnderChoice(LeafRefContext referencedByCtx, QName qname) {
        for (LeafRefContext child : referencedByCtx.getReferencedByChilds().values()) {
            LeafRefContext referencedByChildByName = child.getReferencedChildByName(qname);
            if (referencedByChildByName == null) continue;
            return referencedByChildByName;
        }
        return null;
    }

    private void validateLeafRefTargetNodeData(NormalizedNode<?, ?> leaf, LeafRefContext referencedByCtx, ModificationType modificationType) {
        if (!this.validatedLeafRefCtx.add(referencedByCtx)) {
            LOG.trace("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}] -> SKIP: Already validated", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.getValue()});
            return;
        }
        LOG.trace("Operation [{}] validate data of leafref TARGET node: name[{}] = value[{}]", new Object[]{modificationType, referencedByCtx.getNodeName(), leaf.getValue()});
        Set<LeafRefContext> leafRefs = referencedByCtx.getAllReferencedByLeafRefCtxs().values().stream().filter(LeafRefContext::isReferencing).collect(Collectors.toSet());
        if (leafRefs.isEmpty()) {
            return;
        }
        Set<Object> leafRefTargetNodeValues = this.extractRootValues(referencedByCtx);
        leafRefs.forEach(leafRefContext -> this.extractRootValues((LeafRefContext)((Object)leafRefContext)).forEach(leafRefsValue -> {
            if (leafRefTargetNodeValues.contains(leafRefsValue)) {
                LOG.trace("Valid leafref value [{}] {}", leafRefsValue, (Object)SUCCESS);
                return;
            }
            LOG.debug("Invalid leafref value [{}] allowed values {} by validation of leafref TARGET node: {} path of invalid LEAFREF node: {} leafRef target path: {} {}", new Object[]{leafRefsValue, leafRefTargetNodeValues, leaf.getNodeType(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED});
            this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s by validation of leafref TARGET node: %s path of invalid LEAFREF node: %s leafRef target path: %s %s", leafRefsValue, leafRefTargetNodeValues, leaf.getNodeType(), leafRefContext.getCurrentNodePath(), leafRefContext.getAbsoluteLeafRefTargetPath(), FAILED));
        }));
    }

    private Set<Object> extractRootValues(LeafRefContext context) {
        return this.computeValues(this.root, LeafRefValidation.createPath(context.getLeafRefNodePath()), null);
    }

    private void validateLeafRefNodeData(NormalizedNode<?, ?> leaf, LeafRefContext referencingCtx, ModificationType modificationType, YangInstanceIdentifier current) {
        Set<Object> values = this.computeValues(this.root, LeafRefValidation.createPath(referencingCtx.getAbsoluteLeafRefTargetPath()), current);
        if (values.contains(leaf.getValue())) {
            LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.getValue(), SUCCESS});
            return;
        }
        LOG.debug("Operation [{}] validate data of LEAFREF node: name[{}] = value[{}] {}", new Object[]{modificationType, referencingCtx.getNodeName(), leaf.getValue(), FAILED});
        LOG.debug("Invalid leafref value [{}] allowed values {} of LEAFREF node: {} leafRef target path: {}", new Object[]{leaf.getValue(), values, leaf.getNodeType(), referencingCtx.getAbsoluteLeafRefTargetPath()});
        this.errorsMessages.add(String.format("Invalid leafref value [%s] allowed values %s of LEAFREF node: %s leafRef target path: %s", leaf.getValue(), values, leaf.getNodeType(), referencingCtx.getAbsoluteLeafRefTargetPath()));
    }

    private Set<Object> computeValues(NormalizedNode<?, ?> node, Deque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        HashSet<Object> values = new HashSet<Object>();
        this.addValues(values, node, (List<QNamePredicate>)ImmutableList.of(), path, current);
        return values;
    }

    private void addValues(Set<Object> values, NormalizedNode<?, ?> node, List<QNamePredicate> nodePredicates, Deque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        if (node instanceof ValueNode) {
            values.add(node.getValue());
            return;
        }
        if (node instanceof LeafSetNode) {
            for (NormalizedNode entry : ((LeafSetNode)node).getValue()) {
                values.add(entry.getValue());
            }
            return;
        }
        QNameWithPredicate next = path.peek();
        if (next == null) {
            return;
        }
        YangInstanceIdentifier.NodeIdentifier pathArgument = new YangInstanceIdentifier.NodeIdentifier(next.getQName());
        if (node instanceof DataContainerNode) {
            this.processChildNode(values, (DataContainerNode)node, (YangInstanceIdentifier.PathArgument)pathArgument, next.getQNamePredicates(), path, current);
        } else if (node instanceof MapNode) {
            Stream<Object> entries = ((MapNode)node).getValue().stream();
            if (!nodePredicates.isEmpty() && current != null) {
                entries = entries.filter(this.createMapEntryPredicate(nodePredicates, current));
            }
            entries.forEach(arg_0 -> this.lambda$addValues$2(values, (YangInstanceIdentifier.PathArgument)pathArgument, next, path, current, arg_0));
        }
    }

    private void processChildNode(Set<Object> values, DataContainerNode<?> parent, YangInstanceIdentifier.PathArgument arg, List<QNamePredicate> nodePredicates, Deque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        Optional child = parent.getChild(arg);
        if (!child.isPresent()) {
            for (DataContainerChild mixin : parent.getValue()) {
                if (!(mixin instanceof AugmentationNode) && !(mixin instanceof ChoiceNode)) continue;
                this.addValues(values, (NormalizedNode<?, ?>)mixin, nodePredicates, path, current);
            }
        } else {
            this.addNextValues(values, (NormalizedNode)child.get(), nodePredicates, path, current);
        }
    }

    private Predicate<MapEntryNode> createMapEntryPredicate(List<QNamePredicate> nodePredicates, YangInstanceIdentifier current) {
        HashMap keyValues = new HashMap();
        for (QNamePredicate predicate : nodePredicates) {
            keyValues.put((QName)predicate.getIdentifier(), this.getPathKeyExpressionValues(predicate.getPathKeyExpression(), current));
        }
        return mapEntry -> {
            for (Map.Entry entryKeyValue : mapEntry.getIdentifier().entrySet()) {
                Set allowedValues = (Set)keyValues.get(entryKeyValue.getKey());
                if (allowedValues == null || allowedValues.contains(entryKeyValue.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNextValues(Set<Object> values, NormalizedNode<?, ?> node, List<QNamePredicate> nodePredicates, Deque<QNameWithPredicate> path, YangInstanceIdentifier current) {
        QNameWithPredicate element = path.pop();
        try {
            this.addValues(values, node, nodePredicates, path, current);
        }
        finally {
            path.push(element);
        }
    }

    private Set<?> getPathKeyExpressionValues(LeafRefPath predicatePathKeyExpression, YangInstanceIdentifier current) {
        return LeafRefValidation.findParentNode(Optional.of(this.root), current).map(parent -> {
            Deque<QNameWithPredicate> path = LeafRefValidation.createPath(predicatePathKeyExpression);
            path.pollFirst();
            return this.computeValues((NormalizedNode<?, ?>)parent, path, null);
        }).orElse((Set)ImmutableSet.of());
    }

    private static Optional<NormalizedNode<?, ?>> findParentNode(Optional<NormalizedNode<?, ?>> root, YangInstanceIdentifier path) {
        Optional currentNode = root;
        Iterator pathIterator = path.getPathArguments().iterator();
        while (pathIterator.hasNext()) {
            YangInstanceIdentifier.PathArgument childPathArgument = (YangInstanceIdentifier.PathArgument)pathIterator.next();
            if (pathIterator.hasNext() && currentNode.isPresent()) {
                currentNode = NormalizedNodes.getDirectChild(currentNode.get(), (YangInstanceIdentifier.PathArgument)childPathArgument);
                continue;
            }
            return currentNode;
        }
        return Optional.empty();
    }

    private static Deque<QNameWithPredicate> createPath(LeafRefPath path) {
        ArrayDeque<QNameWithPredicate> ret = new ArrayDeque<QNameWithPredicate>();
        path.getPathTowardsRoot().forEach(ret::push);
        return ret;
    }

    private /* synthetic */ void lambda$addValues$2(Set values, YangInstanceIdentifier.PathArgument pathArgument, QNameWithPredicate next, Deque path, YangInstanceIdentifier current, MapEntryNode entry) {
        this.processChildNode(values, (DataContainerNode<?>)entry, pathArgument, next.getQNamePredicates(), path, current);
    }
}

