/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.impl.leafref.AbstractQNameWithPredicate;
import org.opendaylight.yangtools.yang.data.impl.leafref.QNamePredicate;

final class QNameWithPredicateImpl
extends AbstractQNameWithPredicate {
    private final ImmutableList<QNamePredicate> qnamePredicates;
    private final QNameModule moduleQname;
    private final String localName;

    QNameWithPredicateImpl(QNameModule moduleQname, String localName, List<QNamePredicate> qnamePredicates) {
        this.moduleQname = moduleQname;
        this.localName = localName;
        this.qnamePredicates = ImmutableList.copyOf(qnamePredicates);
    }

    @Override
    public List<QNamePredicate> getQNamePredicates() {
        return this.qnamePredicates;
    }

    @Override
    public QNameModule getModuleQname() {
        return this.moduleQname;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public QName getQName() {
        return QName.create((QNameModule)this.moduleQname, (String)this.localName);
    }
}

