/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOrderedNormalizedNodeWriter
extends NormalizedNodeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOrderedNormalizedNodeWriter.class);
    private final SchemaContext schemaContext;
    private final SchemaNode root;
    private SchemaNode currentSchemaNode;

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaContext schemaContext, SchemaPath path) {
        super(writer);
        this.schemaContext = schemaContext;
        Collection<SchemaNode> schemaNodes = SchemaUtils.findParentSchemaNodesOnPath(schemaContext, path);
        Preconditions.checkArgument((!schemaNodes.isEmpty() ? 1 : 0) != 0, (String)"Unable to find schema node for supplied schema path: %s", (Object)path);
        if (schemaNodes.size() > 1) {
            LOG.warn("More possible schema nodes {} for supplied schema path {}", schemaNodes, (Object)path);
        }
        this.root = schemaNodes.iterator().next();
    }

    public SchemaOrderedNormalizedNodeWriter write(NormalizedNode<?, ?> node) throws IOException {
        this.currentSchemaNode = Objects.equals(this.root, this.schemaContext) ? this.schemaContext.getDataChildByName(node.getNodeType()) : this.root;
        return this.write(node, this.currentSchemaNode);
    }

    public SchemaOrderedNormalizedNodeWriter write(Collection<DataContainerChild<?, ?>> nodes) throws IOException {
        this.currentSchemaNode = this.root;
        if (this.writeChildren(nodes, this.currentSchemaNode, false)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize nodes " + nodes);
    }

    private SchemaOrderedNormalizedNodeWriter write(NormalizedNode<?, ?> node, SchemaNode dataSchemaNode) throws IOException {
        try (SchemaNodeSetter sns = new SchemaNodeSetter(dataSchemaNode);){
            if (node == null) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessedAsCompositeNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessAsSimpleNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private void write(List<NormalizedNode<?, ?>> nodes, SchemaNode dataSchemaNode) throws IOException {
        for (NormalizedNode<?, ?> node : nodes) {
            this.write(node, dataSchemaNode);
        }
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children) throws IOException {
        return this.writeChildren(children, this.currentSchemaNode, true);
    }

    private boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children, SchemaNode parentSchemaNode, boolean endParent) throws IOException {
        ArrayListMultimap qNameToNodes = ArrayListMultimap.create();
        for (NormalizedNode<?, ?> normalizedNode : children) {
            if (normalizedNode instanceof AugmentationNode) {
                qNameToNodes.putAll(this.resolveAugmentations(normalizedNode));
                continue;
            }
            qNameToNodes.put((Object)normalizedNode.getNodeType(), normalizedNode);
        }
        if (parentSchemaNode instanceof DataNodeContainer) {
            if (parentSchemaNode instanceof ListSchemaNode && qNameToNodes.containsKey((Object)parentSchemaNode.getQName())) {
                this.write(qNameToNodes.get((Object)parentSchemaNode.getQName()), parentSchemaNode);
            } else {
                for (DataSchemaNode dataSchemaNode : ((DataNodeContainer)parentSchemaNode).getChildNodes()) {
                    this.write(qNameToNodes.get((Object)dataSchemaNode.getQName()), (SchemaNode)dataSchemaNode);
                }
            }
        } else if (parentSchemaNode instanceof ChoiceSchemaNode) {
            for (CaseSchemaNode caseSchemaNode : ((ChoiceSchemaNode)parentSchemaNode).getCases()) {
                for (DataSchemaNode dsn : caseSchemaNode.getChildNodes()) {
                    if (!qNameToNodes.containsKey((Object)dsn.getQName())) continue;
                    this.write(qNameToNodes.get((Object)dsn.getQName()), (SchemaNode)dsn);
                }
            }
        } else {
            for (NormalizedNode normalizedNode : children) {
                this.writeLeaf(normalizedNode);
            }
        }
        if (endParent) {
            this.getWriter().endNode();
        }
        return true;
    }

    private SchemaOrderedNormalizedNodeWriter writeLeaf(NormalizedNode<?, ?> node) throws IOException {
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private ArrayListMultimap<QName, NormalizedNode<?, ?>> resolveAugmentations(NormalizedNode<?, ?> child) {
        ArrayListMultimap resolvedAugs = ArrayListMultimap.create();
        for (NormalizedNode node : ((AugmentationNode)child).getValue()) {
            if (node instanceof AugmentationNode) {
                resolvedAugs.putAll(this.resolveAugmentations(node));
                continue;
            }
            resolvedAugs.put((Object)node.getNodeType(), (Object)node);
        }
        return resolvedAugs;
    }

    private final class SchemaNodeSetter
    implements AutoCloseable {
        private final SchemaNode previousSchemaNode;

        SchemaNodeSetter(SchemaNode schemaNode) {
            this.previousSchemaNode = SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode;
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = schemaNode;
        }

        @Override
        public void close() {
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = this.previousSchemaNode;
        }
    }
}

