/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataNodeContainerValidator;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class ImmutableMapEntryNodeSchemaAwareBuilder
extends ImmutableMapEntryNodeBuilder {
    private final ListSchemaNode schema;
    private final DataNodeContainerValidator validator;

    ImmutableMapEntryNodeSchemaAwareBuilder(ListSchemaNode schema) {
        this.schema = Objects.requireNonNull(schema);
        this.validator = new DataNodeContainerValidator((DataNodeContainer)schema);
    }

    public ImmutableMapEntryNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifierWithPredicates withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withChild(DataContainerChild<?, ?> child) {
        this.validator.validateChild(child.getIdentifier());
        return super.withChild(child);
    }

    @Override
    public MapEntryNode build() {
        super.withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.constructNodeIdentifier());
        return super.build();
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(ListSchemaNode schema) {
        return new ImmutableMapEntryNodeSchemaAwareBuilder(schema);
    }

    private YangInstanceIdentifier.NodeIdentifierWithPredicates constructNodeIdentifier() {
        List keys = this.schema.getKeyDefinition();
        Object predicates = !keys.isEmpty() ? this.keyDefToPredicates(keys) : (!this.childrenQNamesToPaths.isEmpty() ? this.childrenToPredicates() : ImmutableMap.of());
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)this.schema.getQName(), (Map)predicates);
    }

    private Map<QName, Object> childrenToPredicates() {
        Object[] values = new Object[this.childrenQNamesToPaths.size()];
        int offset = 0;
        for (Map.Entry entry : this.childrenQNamesToPaths.entrySet()) {
            values[offset++] = this.nonnullKeyValue((QName)entry.getKey(), this.getChild((YangInstanceIdentifier.PathArgument)entry.getValue())).getValue();
        }
        return ImmutableMapTemplate.ordered(this.childrenQNamesToPaths.keySet()).instantiateWithValues(values);
    }

    private Map<QName, Object> keyDefToPredicates(Collection<QName> keys) {
        Object[] values = new Object[keys.size()];
        int offset = 0;
        for (QName key : keys) {
            values[offset++] = this.nonnullKeyValue(key, this.getChild((YangInstanceIdentifier.PathArgument)this.childrenQNamesToPaths.get(key))).getValue();
        }
        return ImmutableMapTemplate.ordered(keys).instantiateWithValues(values);
    }

    private DataContainerChild<?, ?> nonnullKeyValue(QName key, DataContainerChild<?, ?> value) {
        if (value != null) {
            return value;
        }
        throw new DataValidationException.IllegalListKeyException("Key value not present for key: %s, in: %s values %s", key, this.schema.getQName(), this.buildValue());
    }
}

