/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

final class AutomaticLifecycleMixin {
    private AutomaticLifecycleMixin() {
    }

    static Optional<? extends TreeNode> apply(Apply delegate, ApplyWrite writeDelegate, NormalizedNode<?, ?> emptyNode, ModifiedNode modification, Optional<? extends TreeNode> storeMeta, Version version) {
        Optional<? extends TreeNode> ret;
        if (modification.getOperation() == LogicalOperation.DELETE) {
            if (modification.getChildren().isEmpty()) {
                return delegate.apply(modification, storeMeta, version);
            }
            ret = Optional.of(writeDelegate.applyWrite(modification, emptyNode, storeMeta, version));
        } else {
            ret = modification.getOperation() == LogicalOperation.TOUCH && !storeMeta.isPresent() ? AutomaticLifecycleMixin.applyTouch(delegate, emptyNode, modification, storeMeta, version) : delegate.apply(modification, storeMeta, version);
        }
        return ret.isPresent() ? AutomaticLifecycleMixin.disappearResult(modification, ret.get(), storeMeta) : ret;
    }

    private static Optional<? extends TreeNode> applyTouch(Apply delegate, NormalizedNode<?, ?> emptyNode, ModifiedNode modification, Optional<? extends TreeNode> storeMeta, Version version) {
        Optional<? extends TreeNode> ret = delegate.apply(modification, AutomaticLifecycleMixin.fakeMeta(emptyNode, version), version);
        if (modification.getModificationType() == ModificationType.SUBTREE_MODIFIED) {
            modification.resolveModificationType(ModificationType.APPEARED);
        }
        return ret;
    }

    private static Optional<? extends TreeNode> disappearResult(ModifiedNode modification, TreeNode result, Optional<? extends TreeNode> storeMeta) {
        if (!AutomaticLifecycleMixin.isEmpty(result)) {
            return Optional.of(result);
        }
        ModificationType finalType = !storeMeta.isPresent() ? ModificationType.UNMODIFIED : (modification.getModificationType() == ModificationType.WRITE ? ModificationType.DELETE : ModificationType.DISAPPEARED);
        modification.resolveModificationType(finalType);
        return Optional.empty();
    }

    private static Optional<TreeNode> fakeMeta(NormalizedNode<?, ?> emptyNode, Version version) {
        return Optional.of(TreeNodeFactory.createTreeNode(emptyNode, (Version)version));
    }

    private static boolean isEmpty(TreeNode treeNode) {
        NormalizedNode data = treeNode.getData();
        if (data instanceof NormalizedNodeContainer) {
            return ((NormalizedNodeContainer)data).getValue().isEmpty();
        }
        if (data instanceof OrderedNodeContainer) {
            return ((OrderedNodeContainer)data).getSize() == 0;
        }
        throw new IllegalStateException("Unhandled data " + data);
    }

    @FunctionalInterface
    static interface ApplyWrite {
        public TreeNode applyWrite(ModifiedNode var1, NormalizedNode<?, ?> var2, Optional<? extends TreeNode> var3, Version var4);
    }

    @FunctionalInterface
    static interface Apply {
        public Optional<? extends TreeNode> apply(ModifiedNode var1, Optional<? extends TreeNode> var2, Version var3);
    }
}

