/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

final class OperationWithModification {
    private final ModificationApplyOperation applyOperation;
    private final ModifiedNode modification;

    private OperationWithModification(ModificationApplyOperation op, ModifiedNode mod) {
        this.applyOperation = Objects.requireNonNull(op);
        this.modification = Objects.requireNonNull(mod);
    }

    void write(NormalizedNode<?, ?> value) {
        this.modification.write(value);
        this.applyOperation.quickVerifyStructure(value);
    }

    void merge(NormalizedNode<?, ?> data, Version version) {
        this.applyOperation.quickVerifyStructure(data);
        this.applyOperation.mergeIntoModifiedNode(this.modification, data, version);
    }

    void delete() {
        this.modification.delete();
    }

    Optional<NormalizedNode<?, ?>> read(YangInstanceIdentifier.PathArgument child, Version version) {
        Optional<ModifiedNode> maybeChild = this.modification.getChild(child);
        if (maybeChild.isPresent()) {
            ModifiedNode childNode = maybeChild.get();
            Optional<TreeNode> snapshot = childNode.getSnapshot();
            if (snapshot == null) {
                snapshot = this.applyOperation.getChild(child).get().apply(childNode, childNode.getOriginal(), version);
            }
            return snapshot.map(TreeNode::getData);
        }
        Optional<TreeNode> snapshot = this.modification.getSnapshot();
        if (snapshot == null) {
            snapshot = this.apply(this.modification.getOriginal(), version);
        }
        if (snapshot.isPresent()) {
            return snapshot.get().getChild(child).map(TreeNode::getData);
        }
        return Optional.empty();
    }

    public ModifiedNode getModification() {
        return this.modification;
    }

    public ModificationApplyOperation getApplyOperation() {
        return this.applyOperation;
    }

    public Optional<? extends TreeNode> apply(Optional<? extends TreeNode> data, Version version) {
        return this.applyOperation.apply(this.modification, data, version);
    }

    public static OperationWithModification from(ModificationApplyOperation operation, ModifiedNode modification) {
        return new OperationWithModification(operation, modification);
    }
}

