/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.AbstractMountPointChild;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.xml.sax.SAXException;

@NonNullByDefault
final class DOMSourceMountPointChild
extends AbstractMountPointChild {
    private final DOMSource source;

    DOMSourceMountPointChild(DOMSource source) {
        this.source = Objects.requireNonNull(source);
    }

    public void writeTo(NormalizedNodeStreamWriter writer, MountPointContext mountCtx) throws IOException {
        XmlParserStream xmlParser;
        try {
            xmlParser = XmlParserStream.create(writer, mountCtx, (SchemaNode)mountCtx.getSchemaContext());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to instantiate XML parser", e);
        }
        try {
            DOMSourceXMLStreamReader reader = new DOMSourceXMLStreamReader(this.source);
            xmlParser.parse((XMLStreamReader)((Object)reader)).flush();
        }
        catch (URISyntaxException | XMLStreamException | SAXException e) {
            throw new IOException("Failed to parse payload", e);
        }
    }
}

